/*
 * Decompiled with CFR 0.152.
 */
package io.github.marceltanuri.commons.oauthclient.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.marceltanuri.commons.oauthclient.api.OAuth2ClientException;
import io.github.marceltanuri.commons.oauthclient.api.OAuth2ClientSettings;
import io.github.marceltanuri.commons.oauthclient.api.OAuth2Service;
import io.github.marceltanuri.commons.oauthclient.internal.OAuth2TokenCache;
import io.github.marceltanuri.commons.oauthclient.internal.TokenResponse;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.stream.Collectors;

public class OAuth2ClientService
implements OAuth2Service {
    private final OAuth2TokenCache _cache;
    private final HttpClient _httpClient;
    private final ObjectMapper _objectMapper = new ObjectMapper();
    private final OAuth2ClientSettings _settings;

    public OAuth2ClientService(OAuth2ClientSettings settings, OAuth2TokenCache cache) {
        this._settings = settings;
        this._cache = cache;
        this._httpClient = HttpClient.newHttpClient();
    }

    @Override
    public String getAccessToken() {
        String scope = this._settings.scope();
        String cacheKey = this._settings.clientId() + ":" + scope;
        TokenResponse token = this._cache.get(cacheKey);
        if (token != null) {
            return token.getAccessToken();
        }
        token = this._fetchAccessToken();
        this._cache.put(cacheKey, token);
        return token.getAccessToken();
    }

    private TokenResponse _fetchAccessToken() {
        String audience;
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("client_id", this._settings.clientId());
        formData.put("client_secret", this._settings.clientSecret());
        formData.put("grant_type", "client_credentials");
        String scope = this._settings.scope();
        if (scope != null && !scope.isBlank()) {
            formData.put("scope", scope);
        }
        if ((audience = this._settings.audience()) != null && !audience.isBlank()) {
            formData.put("audience", audience);
        }
        String form = formData.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this._settings.tokenEndpoint())).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(form, StandardCharsets.UTF_8)).build();
        try {
            HttpResponse<String> response = this._httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                return (TokenResponse)this._objectMapper.readValue(response.body(), TokenResponse.class);
            }
            throw new OAuth2ClientException("Failed to retrieve access token. Status code: " + response.statusCode());
        }
        catch (IOException | InterruptedException exception) {
            throw new OAuth2ClientException("Error fetching access token", exception);
        }
    }
}

