/*
 * Decompiled with CFR 0.152.
 */
package com.wang.avi.indicators;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.animation.LinearInterpolator;
import com.wang.avi.Indicator;
import java.util.ArrayList;

public class OrbitIndicator
extends Indicator {
    private float ring1Scale = 0.0f;
    private float ring1Alpha = 1.0f;
    private float ring2Scale = 0.0f;
    private float ring2Alpha = 1.0f;
    private float coreScale = 1.0f;
    private float satelliteRotation = 0.0f;
    private final float satelliteCoreRatio = 0.25f;
    private final float distanceRatio = 1.5f;

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float size = Math.min(this.getWidth(), this.getHeight());
        float centerX = (float)this.getWidth() / 2.0f;
        float centerY = (float)this.getHeight() / 2.0f;
        float coreSize = size / 2.75f;
        float satelliteSize = coreSize * 0.25f;
        Paint ringPaint1 = new Paint(paint);
        ringPaint1.setStyle(Paint.Style.FILL);
        ringPaint1.setAlpha((int)(this.ring1Alpha * 255.0f * 0.6f));
        canvas.save();
        canvas.translate(centerX, centerY);
        canvas.scale(this.ring1Scale, this.ring1Scale);
        canvas.drawCircle(0.0f, 0.0f, coreSize / 2.0f, ringPaint1);
        canvas.restore();
        Paint ringPaint2 = new Paint(paint);
        ringPaint2.setStyle(Paint.Style.FILL);
        ringPaint2.setAlpha((int)(this.ring2Alpha * 255.0f * 0.6f));
        canvas.save();
        canvas.translate(centerX, centerY);
        canvas.scale(this.ring2Scale, this.ring2Scale);
        canvas.drawCircle(0.0f, 0.0f, coreSize / 2.0f, ringPaint2);
        canvas.restore();
        canvas.save();
        canvas.translate(centerX, centerY);
        canvas.scale(this.coreScale, this.coreScale);
        canvas.drawCircle(0.0f, 0.0f, coreSize / 2.0f, paint);
        canvas.restore();
        canvas.save();
        canvas.translate(centerX, centerY);
        canvas.rotate(this.satelliteRotation);
        canvas.translate((size - satelliteSize) / 2.0f, 0.0f);
        canvas.drawCircle(0.0f, 0.0f, satelliteSize / 2.0f, paint);
        canvas.restore();
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        int duration = 1900;
        ValueAnimator ring1Anim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        ring1Anim.setDuration((long)duration);
        ring1Anim.setRepeatCount(-1);
        this.addUpdateListener(ring1Anim, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float progress = ((Float)animation.getAnimatedValue()).floatValue();
                if (progress <= 0.45f) {
                    OrbitIndicator.this.ring1Scale = 0.0f;
                    OrbitIndicator.this.ring1Alpha = 1.0f;
                } else {
                    float scaleProgress = (progress - 0.45f) / 0.55f;
                    OrbitIndicator.this.ring1Scale = scaleProgress * 2.5f;
                    OrbitIndicator.this.ring1Alpha = 1.0f - scaleProgress;
                }
                OrbitIndicator.this.postInvalidate();
            }
        });
        animators.add(ring1Anim);
        ValueAnimator ring2Anim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        ring2Anim.setDuration((long)duration);
        ring2Anim.setRepeatCount(-1);
        this.addUpdateListener(ring2Anim, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float progress = ((Float)animation.getAnimatedValue()).floatValue();
                if (progress <= 0.55f) {
                    OrbitIndicator.this.ring2Scale = 0.0f;
                    OrbitIndicator.this.ring2Alpha = 1.0f;
                } else {
                    float scaleProgress = (progress - 0.55f) / 0.45f;
                    OrbitIndicator.this.ring2Scale = scaleProgress * 2.6f;
                    if (progress <= 0.65f) {
                        OrbitIndicator.this.ring2Alpha = 1.0f;
                    } else {
                        float alphaProgress = (progress - 0.65f) / 0.35f;
                        OrbitIndicator.this.ring2Alpha = 1.0f - alphaProgress;
                    }
                }
                OrbitIndicator.this.postInvalidate();
            }
        });
        animators.add(ring2Anim);
        ValueAnimator coreScaleAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        coreScaleAnim.setDuration((long)duration);
        coreScaleAnim.setRepeatCount(-1);
        this.addUpdateListener(coreScaleAnim, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float progress = ((Float)animation.getAnimatedValue()).floatValue();
                if (progress <= 0.45f) {
                    float scaleProgress = progress / 0.45f;
                    OrbitIndicator.this.coreScale = 1.0f + scaleProgress * 0.3f;
                } else if (progress <= 0.55f) {
                    OrbitIndicator.this.coreScale = 1.3f;
                } else {
                    float scaleProgress = (progress - 0.55f) / 0.45f;
                    OrbitIndicator.this.coreScale = 1.3f - scaleProgress * 0.3f;
                }
                OrbitIndicator.this.postInvalidate();
            }
        });
        animators.add(coreScaleAnim);
        ValueAnimator satelliteRotationAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 360.0f});
        satelliteRotationAnim.setDuration((long)duration);
        satelliteRotationAnim.setRepeatCount(-1);
        satelliteRotationAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.addUpdateListener(satelliteRotationAnim, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                OrbitIndicator.this.satelliteRotation = ((Float)animation.getAnimatedValue()).floatValue();
                OrbitIndicator.this.postInvalidate();
            }
        });
        animators.add(satelliteRotationAnim);
        return animators;
    }
}

