/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.server.model.federation.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.event.Unsigned;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.github.ma1uta.matrix.server.model.federation.PersistedDataUnit;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="These events are broadcast from one homeserver to any others that have joined the same room (identified by Room ID). They are persisted in long-term storage and record the history of messages and state for a room.")
public class PDUv1
implements PersistedDataUnit {
    @Schema(name="room_id", description="Room identifier.", required=true)
    @JsonbProperty(value="room_id")
    private String roomId;
    @Schema(description="The ID of the user sending the event.", required=true)
    private String sender;
    @Schema(description="server_name of the homeserver that created this event.", required=true)
    private String origin;
    @Schema(name="event_id", description="Unique identifier for the event being sent.", required=true)
    @JsonbProperty(value="event_id")
    private String eventId;
    @Schema(name="origin_server_ts", description="Timestamp in milliseconds on origin homeserver when this event was created.", required=true)
    @JsonbProperty(value="origin_server_ts")
    private Long originServerTs;
    @Schema(description="Event type.", required=true)
    private String type;
    @Schema(name="state_key", description="If this key is present, the event is a state event, and it will replace previous events with the same type and state_key in the room state.")
    @JsonbProperty(value="state_key")
    private String stateKey;
    @Schema(description="The content of the event.")
    private EventContent content;
    @JsonbProperty(value="prev_events")
    private List<Map<String, Map<String, String>>> prevEvents;
    @Schema(description="The maximum depth of the prev_events, plus one.", required=true)
    private Long depth;
    @Schema(name="auth_events", description="Event IDs and hashes for the \"auth events\" of this event.", required=true)
    @JsonbProperty(value="auth_events")
    private List<Map<String, Map<String, String>>> authEvents;
    @Schema(description="Hashes of the PDU, following the algorithm specified in Signing Events.", required=true)
    private Map<String, String> hashes;
    @Schema(description="Signatures of the redacted PDU, following the algorithm specified in Signing Events.", required=true)
    private Map<String, Map<String, String>> signatures;
    @Schema(description="For redaction events, the ID of the event being redacted.")
    private String redacts;
    @Schema(description="Additional data added by the origin server but not covered by the signatures.")
    private Unsigned unsigned;

    @JsonProperty(value="room_id")
    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    @JsonProperty(value="event_id")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    @JsonProperty(value="origin_server_ts")
    public Long getOriginServerTs() {
        return this.originServerTs;
    }

    public void setOriginServerTs(Long originServerTs) {
        this.originServerTs = originServerTs;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="state_key")
    public String getStateKey() {
        return this.stateKey;
    }

    public void setStateKey(String stateKey) {
        this.stateKey = stateKey;
    }

    public EventContent getContent() {
        return this.content;
    }

    public void setContent(EventContent content) {
        this.content = content;
    }

    @JsonProperty(value="prev_events")
    public List<Map<String, Map<String, String>>> getPrevEvents() {
        return this.prevEvents;
    }

    public void setPrevEvents(List<Map<String, Map<String, String>>> prevEvents) {
        this.prevEvents = prevEvents;
    }

    public Long getDepth() {
        return this.depth;
    }

    public void setDepth(Long depth) {
        this.depth = depth;
    }

    @JsonProperty(value="auth_events")
    public List<Map<String, Map<String, String>>> getAuthEvents() {
        return this.authEvents;
    }

    public void setAuthEvents(List<Map<String, Map<String, String>>> authEvents) {
        this.authEvents = authEvents;
    }

    public Map<String, String> getHashes() {
        return this.hashes;
    }

    public void setHashes(Map<String, String> hashes) {
        this.hashes = hashes;
    }

    public Map<String, Map<String, String>> getSignatures() {
        return this.signatures;
    }

    public void setSignatures(Map<String, Map<String, String>> signatures) {
        this.signatures = signatures;
    }

    public String getRedacts() {
        return this.redacts;
    }

    public void setRedacts(String redacts) {
        this.redacts = redacts;
    }

    public Unsigned getUnsigned() {
        return this.unsigned;
    }

    public void setUnsigned(Unsigned unsigned) {
        this.unsigned = unsigned;
    }
}

