/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.support.jsonb;

import io.github.ma1uta.matrix.event.content.RoomEncryptedContent;
import io.github.ma1uta.matrix.event.encrypted.MegolmEncryptedContent;
import io.github.ma1uta.matrix.event.encrypted.OlmEncryptedContent;
import io.github.ma1uta.matrix.event.encrypted.RawEncryptedContent;
import java.lang.reflect.Type;
import javax.json.JsonObject;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;

public class RoomEncryptedContentDeserializer
implements JsonbDeserializer<RoomEncryptedContent> {
    private Jsonb jsonb = JsonbBuilder.create();

    protected Jsonb jsonb() {
        return this.jsonb;
    }

    public RoomEncryptedContent deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
        JsonObject object = parser.getObject();
        if (object.get((Object)"algorithm") == null || object.isNull("algorithm")) {
            return this.parse(object, null, ctx);
        }
        String algorithm = object.getString("algorithm");
        String objectSource = object.toString();
        switch (algorithm) {
            case "m.olm.v1.curve25519-aes-sha2": {
                return (RoomEncryptedContent)this.jsonb().fromJson(objectSource, OlmEncryptedContent.class);
            }
            case "m.megolm.v1.aes-sha2": {
                return (RoomEncryptedContent)this.jsonb().fromJson(objectSource, MegolmEncryptedContent.class);
            }
        }
        return this.parse(object, algorithm, ctx);
    }

    protected RoomEncryptedContent parse(JsonObject jsonObject, String algorithm, DeserializationContext ctx) {
        return new RawEncryptedContent((Object)jsonObject, algorithm);
    }
}

