/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.support.jsonb.mapper;

import io.github.ma1uta.matrix.Signed;
import io.github.ma1uta.matrix.event.CallAnswer;
import io.github.ma1uta.matrix.event.CallCandidates;
import io.github.ma1uta.matrix.event.CallHangup;
import io.github.ma1uta.matrix.event.CallInvite;
import io.github.ma1uta.matrix.event.Direct;
import io.github.ma1uta.matrix.event.Dummy;
import io.github.ma1uta.matrix.event.Event;
import io.github.ma1uta.matrix.event.ForwardedRoomKey;
import io.github.ma1uta.matrix.event.FullyRead;
import io.github.ma1uta.matrix.event.IgnoredUserList;
import io.github.ma1uta.matrix.event.KeyVerificationAccept;
import io.github.ma1uta.matrix.event.KeyVerificationCancel;
import io.github.ma1uta.matrix.event.KeyVerificationKey;
import io.github.ma1uta.matrix.event.KeyVerificationMac;
import io.github.ma1uta.matrix.event.KeyVerificationRequest;
import io.github.ma1uta.matrix.event.KeyVerificationStart;
import io.github.ma1uta.matrix.event.PolicyRuleRoom;
import io.github.ma1uta.matrix.event.PolicyRuleServer;
import io.github.ma1uta.matrix.event.PolicyRuleUser;
import io.github.ma1uta.matrix.event.Presence;
import io.github.ma1uta.matrix.event.PushRules;
import io.github.ma1uta.matrix.event.RawEvent;
import io.github.ma1uta.matrix.event.Receipt;
import io.github.ma1uta.matrix.event.RoomAliases;
import io.github.ma1uta.matrix.event.RoomAvatar;
import io.github.ma1uta.matrix.event.RoomCanonicalAlias;
import io.github.ma1uta.matrix.event.RoomCreate;
import io.github.ma1uta.matrix.event.RoomEncrypted;
import io.github.ma1uta.matrix.event.RoomEncryption;
import io.github.ma1uta.matrix.event.RoomEvent;
import io.github.ma1uta.matrix.event.RoomGuestAccess;
import io.github.ma1uta.matrix.event.RoomHistoryVisibility;
import io.github.ma1uta.matrix.event.RoomJoinRules;
import io.github.ma1uta.matrix.event.RoomKey;
import io.github.ma1uta.matrix.event.RoomKeyRequest;
import io.github.ma1uta.matrix.event.RoomMember;
import io.github.ma1uta.matrix.event.RoomMessage;
import io.github.ma1uta.matrix.event.RoomMessageFeedback;
import io.github.ma1uta.matrix.event.RoomName;
import io.github.ma1uta.matrix.event.RoomPinned;
import io.github.ma1uta.matrix.event.RoomPowerLevels;
import io.github.ma1uta.matrix.event.RoomRedaction;
import io.github.ma1uta.matrix.event.RoomServerAcl;
import io.github.ma1uta.matrix.event.RoomThirdPartyInvite;
import io.github.ma1uta.matrix.event.RoomTombstone;
import io.github.ma1uta.matrix.event.RoomTopic;
import io.github.ma1uta.matrix.event.StateEvent;
import io.github.ma1uta.matrix.event.Sticker;
import io.github.ma1uta.matrix.event.Tag;
import io.github.ma1uta.matrix.event.Typing;
import io.github.ma1uta.matrix.event.Unsigned;
import io.github.ma1uta.matrix.event.content.CallAnswerContent;
import io.github.ma1uta.matrix.event.content.CallCandidatesContent;
import io.github.ma1uta.matrix.event.content.CallHangupContent;
import io.github.ma1uta.matrix.event.content.CallInviteContent;
import io.github.ma1uta.matrix.event.content.DirectContent;
import io.github.ma1uta.matrix.event.content.DummyContent;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.github.ma1uta.matrix.event.content.ForwardedRoomKeyContent;
import io.github.ma1uta.matrix.event.content.FullyReadContent;
import io.github.ma1uta.matrix.event.content.IgnoredUserListContent;
import io.github.ma1uta.matrix.event.content.KeyVerificationAcceptContent;
import io.github.ma1uta.matrix.event.content.KeyVerificationCancelContent;
import io.github.ma1uta.matrix.event.content.KeyVerificationKeyContent;
import io.github.ma1uta.matrix.event.content.KeyVerificationMacContent;
import io.github.ma1uta.matrix.event.content.KeyVerificationRequestContent;
import io.github.ma1uta.matrix.event.content.KeyVerificationStartContent;
import io.github.ma1uta.matrix.event.content.PolicyRuleRoomContent;
import io.github.ma1uta.matrix.event.content.PolicyRuleServerContent;
import io.github.ma1uta.matrix.event.content.PolicyRuleUserContent;
import io.github.ma1uta.matrix.event.content.PresenceContent;
import io.github.ma1uta.matrix.event.content.PushRulesContent;
import io.github.ma1uta.matrix.event.content.RawEventContent;
import io.github.ma1uta.matrix.event.content.ReceiptContent;
import io.github.ma1uta.matrix.event.content.RoomAliasesContent;
import io.github.ma1uta.matrix.event.content.RoomAvatarContent;
import io.github.ma1uta.matrix.event.content.RoomCanonicalAliasContent;
import io.github.ma1uta.matrix.event.content.RoomCreateContent;
import io.github.ma1uta.matrix.event.content.RoomEncryptedContent;
import io.github.ma1uta.matrix.event.content.RoomEncryptionContent;
import io.github.ma1uta.matrix.event.content.RoomGuestAccessContent;
import io.github.ma1uta.matrix.event.content.RoomHistoryVisibilityContent;
import io.github.ma1uta.matrix.event.content.RoomJoinRulesContent;
import io.github.ma1uta.matrix.event.content.RoomKeyContent;
import io.github.ma1uta.matrix.event.content.RoomKeyRequestContent;
import io.github.ma1uta.matrix.event.content.RoomMemberContent;
import io.github.ma1uta.matrix.event.content.RoomMessageContent;
import io.github.ma1uta.matrix.event.content.RoomMessageFeedbackContent;
import io.github.ma1uta.matrix.event.content.RoomNameContent;
import io.github.ma1uta.matrix.event.content.RoomPinnedContent;
import io.github.ma1uta.matrix.event.content.RoomPowerLevelsContent;
import io.github.ma1uta.matrix.event.content.RoomRedactionContent;
import io.github.ma1uta.matrix.event.content.RoomServerAclContent;
import io.github.ma1uta.matrix.event.content.RoomThirdPartyInviteContent;
import io.github.ma1uta.matrix.event.content.RoomTopicContent;
import io.github.ma1uta.matrix.event.content.StickerContent;
import io.github.ma1uta.matrix.event.content.TagContent;
import io.github.ma1uta.matrix.event.content.TombstoneContent;
import io.github.ma1uta.matrix.event.content.TypingContent;
import io.github.ma1uta.matrix.event.encrypted.MegolmEncryptedContent;
import io.github.ma1uta.matrix.event.encrypted.OlmEncryptedContent;
import io.github.ma1uta.matrix.event.encrypted.RawEncryptedContent;
import io.github.ma1uta.matrix.event.message.Audio;
import io.github.ma1uta.matrix.event.message.Emote;
import io.github.ma1uta.matrix.event.message.File;
import io.github.ma1uta.matrix.event.message.FormattedBody;
import io.github.ma1uta.matrix.event.message.Image;
import io.github.ma1uta.matrix.event.message.Location;
import io.github.ma1uta.matrix.event.message.Notice;
import io.github.ma1uta.matrix.event.message.RawMessageContent;
import io.github.ma1uta.matrix.event.message.ServerNotice;
import io.github.ma1uta.matrix.event.message.Text;
import io.github.ma1uta.matrix.event.message.Video;
import io.github.ma1uta.matrix.event.nested.Answer;
import io.github.ma1uta.matrix.event.nested.AudioInfo;
import io.github.ma1uta.matrix.event.nested.Candidate;
import io.github.ma1uta.matrix.event.nested.CiphertextInfo;
import io.github.ma1uta.matrix.event.nested.EncryptedFile;
import io.github.ma1uta.matrix.event.nested.FileInfo;
import io.github.ma1uta.matrix.event.nested.ImageInfo;
import io.github.ma1uta.matrix.event.nested.Invite;
import io.github.ma1uta.matrix.event.nested.JWK;
import io.github.ma1uta.matrix.event.nested.LocationInfo;
import io.github.ma1uta.matrix.event.nested.NotificationPowerLevel;
import io.github.ma1uta.matrix.event.nested.Offer;
import io.github.ma1uta.matrix.event.nested.PreviousRoom;
import io.github.ma1uta.matrix.event.nested.PublicKeys;
import io.github.ma1uta.matrix.event.nested.PushCondition;
import io.github.ma1uta.matrix.event.nested.PushRule;
import io.github.ma1uta.matrix.event.nested.ReceiptInfo;
import io.github.ma1uta.matrix.event.nested.ReceiptTs;
import io.github.ma1uta.matrix.event.nested.Relates;
import io.github.ma1uta.matrix.event.nested.Reply;
import io.github.ma1uta.matrix.event.nested.RequestedKeyInfo;
import io.github.ma1uta.matrix.event.nested.Ruleset;
import io.github.ma1uta.matrix.event.nested.TagInfo;
import io.github.ma1uta.matrix.event.nested.ThumbnailInfo;
import io.github.ma1uta.matrix.event.nested.VideoInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import org.mapstruct.InheritConfiguration;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mapper(unmappedSourcePolicy=ReportingPolicy.IGNORE, imports={JsonValue.class})
public interface EventMapper {
    public static final Logger LOGGER = LoggerFactory.getLogger(EventMapper.class);
    public static final EventMapper INSTANCE = (EventMapper)Mappers.getMapper(EventMapper.class);
    public static final Util UTIL = new Util();
    public static final Jsonb JSONB = JsonbBuilder.create();
    public static final Object EMPTY = new Object();

    default public Event deserialize(JsonObject jsonObject) {
        if (this.isNull((JsonValue)jsonObject)) {
            return null;
        }
        if (jsonObject.get((Object)"type") == null || jsonObject.isNull("type")) {
            return UTIL.parse(jsonObject);
        }
        String type = jsonObject.getString("type");
        try {
            switch (type) {
                case "m.direct": {
                    return this.direct(jsonObject);
                }
                case "m.dummy": {
                    return this.dummy(jsonObject);
                }
                case "m.forwarded_room_key": {
                    return this.forwardedRoomKey(jsonObject);
                }
                case "m.fully_read": {
                    return this.fullyRead(jsonObject);
                }
                case "m.ignored_user_list": {
                    return this.ignoredUserList(jsonObject);
                }
                case "m.key.verification.accept": {
                    return this.keyVerificationAccept(jsonObject);
                }
                case "m.key.verification.cancel": {
                    return this.keyVerificationCancel(jsonObject);
                }
                case "m.key.verification.key": {
                    return this.keyVerificationKey(jsonObject);
                }
                case "m.key.verification.mac": {
                    return this.keyVerificationMac(jsonObject);
                }
                case "m.key.verification.request": {
                    return this.keyVerificationRequest(jsonObject);
                }
                case "m.key.verification.start": {
                    return this.keyVerificationStart(jsonObject);
                }
                case "m.presence": {
                    return this.presence(jsonObject);
                }
                case "m.push_rules": {
                    return this.pushRules(jsonObject);
                }
                case "m.receipt": {
                    return this.receipt(jsonObject);
                }
                case "m.room_key": {
                    return this.roomKey(jsonObject);
                }
                case "m.room_key_request": {
                    return this.roomKeyRequest(jsonObject);
                }
                case "m.tag": {
                    return this.tag(jsonObject);
                }
                case "m.typing": {
                    return this.typing(jsonObject);
                }
                case "m.call.answer": {
                    return this.callAnswer(jsonObject);
                }
                case "m.call.candidates": {
                    return this.callCandidates(jsonObject);
                }
                case "m.call.hangup": {
                    return this.callHangup(jsonObject);
                }
                case "m.call.invite": {
                    return this.callInvite(jsonObject);
                }
                case "m.room.encrypted": {
                    return this.roomEncrypted(jsonObject);
                }
                case "m.room.message": {
                    return this.roomMessage(jsonObject);
                }
                case "m.room.message.feedback": {
                    return this.roomMessageFeedback(jsonObject);
                }
                case "m.room.redaction": {
                    return this.roomRedaction(jsonObject);
                }
                case "m.sticker": {
                    return this.sticker(jsonObject);
                }
                case "m.room.aliases": {
                    return this.roomAliases(jsonObject);
                }
                case "m.room.avatar": {
                    return this.roomAvatar(jsonObject);
                }
                case "m.room.canonical_alias": {
                    return this.roomCanonicalAlias(jsonObject);
                }
                case "m.room.create": {
                    return this.roomCreate(jsonObject);
                }
                case "m.room.encryption": {
                    return this.roomEncryption(jsonObject);
                }
                case "m.room.guest_access": {
                    return this.roomGuestAccess(jsonObject);
                }
                case "m.room.history_visibility": {
                    return this.roomHistoryVisibility(jsonObject);
                }
                case "m.room.join_rules": {
                    return this.roomJoinRules(jsonObject);
                }
                case "m.room.member": {
                    return this.roomMember(jsonObject);
                }
                case "m.room.name": {
                    return this.roomName(jsonObject);
                }
                case "m.room.pinned_events": {
                    return this.roomPinned(jsonObject);
                }
                case "m.room.power_levels": {
                    return this.roomPowerLevels(jsonObject);
                }
                case "m.room.server_acl": {
                    return this.roomServerAcl(jsonObject);
                }
                case "m.room.third_party_invite": {
                    return this.roomThirdPartyInvite(jsonObject);
                }
                case "m.room.tombstone": {
                    return this.roomTombstone(jsonObject);
                }
                case "m.room.topic": {
                    return this.roomTopic(jsonObject);
                }
                case "m.policy.rule.user": {
                    return this.policyRuleUser(jsonObject);
                }
                case "m.policy.rule.room": {
                    return this.policyRuleRoom(jsonObject);
                }
                case "m.policy.rule.server": {
                    return this.policyRuleServer(jsonObject);
                }
            }
            return UTIL.parse(jsonObject);
        }
        catch (Exception e) {
            LOGGER.error("Unable to parse event", (Throwable)e);
            return UTIL.parse(jsonObject);
        }
    }

    default public <T extends EventContent> T deserializeEventContent(JsonObject jsonObject, String type) {
        switch (type) {
            case "m.direct": {
                return (T)this.directContent(jsonObject);
            }
            case "m.dummy": {
                return (T)new DummyContent();
            }
            case "m.forwarded_room_key": {
                return (T)this.forwardedRoomKeyContent(jsonObject);
            }
            case "m.fully_read": {
                return (T)this.fullyReadContent(jsonObject);
            }
            case "m.ignored_user_list": {
                return (T)this.ignoredUserListContent(jsonObject);
            }
            case "m.key.verification.accept": {
                return (T)this.keyVerificationAcceptContent(jsonObject);
            }
            case "m.key.verification.cancel": {
                return (T)this.keyVerificationCancelContent(jsonObject);
            }
            case "m.key.verification.key": {
                return (T)this.keyVerificationKeyContent(jsonObject);
            }
            case "m.key.verification.mac": {
                return (T)this.keyVerificationMacContent(jsonObject);
            }
            case "m.key.verification.request": {
                return (T)this.keyVerificationRequestContent(jsonObject);
            }
            case "m.key.verification.start": {
                return (T)this.keyVerificationStartContent(jsonObject);
            }
            case "m.presence": {
                return (T)this.presenceContent(jsonObject);
            }
            case "m.push_rules": {
                return (T)this.pushRulesContent(jsonObject);
            }
            case "m.receipt": {
                return (T)this.receiptContent(jsonObject);
            }
            case "m.room_key": {
                return (T)this.roomKeyContent(jsonObject);
            }
            case "m.room_key_request": {
                return (T)this.roomKeyRequestContent(jsonObject);
            }
            case "m.tag": {
                return (T)this.tagContent(jsonObject);
            }
            case "m.typing": {
                return (T)this.typingContent(jsonObject);
            }
            case "m.call.answer": {
                return (T)this.callAnswerContent(jsonObject);
            }
            case "m.call.candidates": {
                return (T)this.callCandidatesContent(jsonObject);
            }
            case "m.call.hangup": {
                return (T)this.callHangupContent(jsonObject);
            }
            case "m.call.invite": {
                return (T)this.callInviteContent(jsonObject);
            }
            case "m.room.encrypted": {
                return (T)this.roomEncryptedContent(jsonObject);
            }
            case "m.room.message": {
                return (T)this.roomMessageContent(jsonObject);
            }
            case "m.room.message.feedback": {
                return (T)this.roomMessageFeedbackContent(jsonObject);
            }
            case "m.room.redaction": {
                return (T)this.roomRedactionContent(jsonObject);
            }
            case "m.sticker": {
                return (T)this.stickerContent(jsonObject);
            }
            case "m.room.aliases": {
                return (T)this.roomAliasesContent(jsonObject);
            }
            case "m.room.avatar": {
                return (T)this.roomAvatarContent(jsonObject);
            }
            case "m.room.canonical_alias": {
                return (T)this.roomCanonicalAliasContent(jsonObject);
            }
            case "m.room.create": {
                return (T)this.roomCreateContent(jsonObject);
            }
            case "m.room.encryption": {
                return (T)this.roomEncryptionContent(jsonObject);
            }
            case "m.room.guest_access": {
                return (T)this.roomGuestAccessContent(jsonObject);
            }
            case "m.room.history_visibility": {
                return (T)this.roomHistoryVisibilityContent(jsonObject);
            }
            case "m.room.join_rules": {
                return (T)this.roomJoinRulesContent(jsonObject);
            }
            case "m.room.member": {
                return (T)this.roomMemberContent(jsonObject);
            }
            case "m.room.name": {
                return (T)this.roomNameContent(jsonObject);
            }
            case "m.room.pinned_events": {
                return (T)this.roomPinnedContent(jsonObject);
            }
            case "m.room.power_levels": {
                return (T)this.roomPowerLevelsContent(jsonObject);
            }
            case "m.room.server_acl": {
                return (T)this.roomServerAclContent(jsonObject);
            }
            case "m.room.third_party_invite": {
                return (T)this.roomThirdPartyInviteContent(jsonObject);
            }
            case "m.room.tombstone": {
                return (T)this.tombstoneContent(jsonObject);
            }
            case "m.room.topic": {
                return (T)this.roomTopicContent(jsonObject);
            }
        }
        return (T)new RawEventContent(this.toRawMap(jsonObject));
    }

    default public boolean isNull(JsonValue jsonValue) {
        return jsonValue == null || jsonValue.getValueType() == JsonValue.ValueType.NULL;
    }

    default public boolean isNull(JsonObject jsonObject, String property) {
        return this.isNull((JsonValue)jsonObject) || jsonObject.get((Object)property) == null || jsonObject.isNull(property);
    }

    default public String toString(JsonObject jsonObject, String property) {
        if (this.isNull(jsonObject, property)) {
            return null;
        }
        return jsonObject.getString(property);
    }

    default public String toString(JsonValue jsonValue) {
        if (this.isNull(jsonValue)) {
            return null;
        }
        return ((JsonString)jsonValue).getString();
    }

    default public Long toLong(JsonObject jsonObject, String property) {
        if (this.isNull(jsonObject, property)) {
            return null;
        }
        return this.toLong((JsonValue)jsonObject.getJsonNumber(property));
    }

    default public Long toLong(JsonValue jsonValue) {
        if (this.isNull(jsonValue)) {
            return null;
        }
        return ((JsonNumber)jsonValue).longValue();
    }

    default public Byte toByte(JsonObject jsonObject, String property) {
        if (this.isNull(jsonObject, property)) {
            return null;
        }
        return this.toByte((JsonValue)jsonObject.getJsonNumber(property));
    }

    default public Byte toByte(JsonValue jsonValue) {
        if (this.isNull(jsonValue)) {
            return null;
        }
        return (byte)((JsonNumber)jsonValue).intValue();
    }

    default public Boolean toBoolean(JsonObject jsonObject, String property) {
        if (this.isNull(jsonObject, property)) {
            return null;
        }
        return jsonObject.getBoolean(property) ? Boolean.TRUE : Boolean.FALSE;
    }

    default public JsonObject toObject(JsonValue jsonValue) {
        if (this.isNull(jsonValue)) {
            return null;
        }
        return jsonValue.asJsonObject();
    }

    default public List<String> toStringArray(JsonObject jsonObject, String property) {
        if (this.isNull(jsonObject, property)) {
            return null;
        }
        return this.toStringArray(jsonObject.getJsonArray(property));
    }

    default public List<String> toStringArray(JsonArray jsonArray) {
        if (this.isNull((JsonValue)jsonArray)) {
            return null;
        }
        return jsonArray.stream().filter(Objects::nonNull).map(this::toString).collect(Collectors.toList());
    }

    default public Map<String, String> toStringMap(JsonObject jsonObject) {
        if (this.isNull((JsonValue)jsonObject)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            map.put((String)entry.getKey(), this.toString((JsonValue)entry.getValue()));
        }
        return map;
    }

    default public Map<String, String> toStringMap(JsonObject jsonObject, String property) {
        if (this.isNull(jsonObject, property)) {
            return null;
        }
        return this.toStringMap(jsonObject.getJsonObject(property));
    }

    default public Map<String, Byte> toStringByteMap(JsonObject jsonObject, String property) {
        if (this.isNull(jsonObject, property)) {
            return null;
        }
        HashMap<String, Byte> map = new HashMap<String, Byte>();
        for (Map.Entry entry : jsonObject.getJsonObject(property).entrySet()) {
            map.put((String)entry.getKey(), this.toByte((JsonValue)entry.getValue()));
        }
        return map;
    }

    default public Map<String, Object> toRawMap(JsonObject jsonObject) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            JsonValue value = (JsonValue)entry.getValue();
            map.put((String)entry.getKey(), value == null ? null : UTIL.parse(value));
        }
        return map;
    }

    @Mapping(expression="java(directContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public Direct direct(JsonObject var1);

    default public Dummy dummy(JsonObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        Dummy dummy = new Dummy();
        dummy.setContent((EventContent)new DummyContent());
        return dummy;
    }

    @Mapping(expression="java(forwardedRoomKeyContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public ForwardedRoomKey forwardedRoomKey(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"room_id\"))", target="roomId"), @Mapping(expression="java(fullyReadContent(jsonObject.getJsonObject(\"content\")))", target="content")})
    public FullyRead fullyRead(JsonObject var1);

    @Mapping(expression="java(ignoredUserListContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public IgnoredUserList ignoredUserList(JsonObject var1);

    @Mapping(expression="java(keyVerificationAcceptContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public KeyVerificationAccept keyVerificationAccept(JsonObject var1);

    @Mapping(expression="java(keyVerificationCancelContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public KeyVerificationCancel keyVerificationCancel(JsonObject var1);

    @Mapping(expression="java(keyVerificationKeyContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public KeyVerificationKey keyVerificationKey(JsonObject var1);

    @Mapping(expression="java(keyVerificationMacContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public KeyVerificationMac keyVerificationMac(JsonObject var1);

    @Mapping(expression="java(keyVerificationRequestContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public KeyVerificationRequest keyVerificationRequest(JsonObject var1);

    @Mapping(expression="java(keyVerificationStartContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public KeyVerificationStart keyVerificationStart(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"sender\"))", target="sender"), @Mapping(expression="java(presenceContent(jsonObject.getJsonObject(\"content\")))", target="content")})
    public Presence presence(JsonObject var1);

    @Mapping(expression="java(pushRulesContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public PushRules pushRules(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"room_id\"))", target="roomId"), @Mapping(expression="java(receiptContent(jsonObject.getJsonObject(\"content\")))", target="content")})
    public Receipt receipt(JsonObject var1);

    @Mapping(expression="java(roomKeyContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public RoomKey roomKey(JsonObject var1);

    @Mapping(expression="java(roomKeyRequestContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public RoomKeyRequest roomKeyRequest(JsonObject var1);

    @Mapping(expression="java(tagContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public Tag tag(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"room_id\"))", target="roomId"), @Mapping(expression="java(typingContent(jsonObject.getJsonObject(\"content\")))", target="content")})
    public Typing typing(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"event_id\"))", target="eventId"), @Mapping(expression="java(toString(jsonObject, \"room_id\"))", target="roomId"), @Mapping(expression="java(toString(jsonObject, \"sender\"))", target="sender"), @Mapping(expression="java(toLong(jsonObject, \"origin_server_ts\"))", target="originServerTs"), @Mapping(expression="java(unsigned(jsonObject))", target="unsigned")})
    public void roomEvent(JsonObject var1, @MappingTarget RoomEvent var2);

    default public Unsigned unsigned(JsonObject jsonObject) {
        if (this.isNull(jsonObject, "unsigned")) {
            return null;
        }
        return this.unsigned(jsonObject.getJsonObject("unsigned"), jsonObject.getString("type"));
    }

    default public Unsigned unsigned(JsonObject jsonObject, String type) {
        Unsigned unsigned = new Unsigned();
        unsigned.setAge(this.toLong(jsonObject, "age"));
        unsigned.setRedactedBecause(this.deserialize(jsonObject.getJsonObject("redacted_because")));
        unsigned.setTransactionId(this.toString(jsonObject, "transaction_id"));
        unsigned.setPrevContent(this.deserializeEventContent(jsonObject.getJsonObject("prev_content"), type));
        if (!this.isNull(jsonObject, "invite_room_state")) {
            unsigned.setInviteRoomState(jsonObject.getJsonArray("invite_room_state").stream().map(JsonValue::asJsonObject).map(this::deserialize).collect(Collectors.toList()));
        }
        return unsigned;
    }

    @InheritConfiguration
    @Mapping(expression="java(callAnswerContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public CallAnswer callAnswer(JsonObject var1);

    @InheritConfiguration
    @Mapping(expression="java(callCandidatesContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public CallCandidates callCandidates(JsonObject var1);

    @InheritConfiguration
    @Mapping(expression="java(callHangupContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public CallHangup callHangup(JsonObject var1);

    @InheritConfiguration
    @Mapping(expression="java(callInviteContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public CallInvite callInvite(JsonObject var1);

    @InheritConfiguration
    @Mapping(expression="java(roomEncryptedContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public RoomEncrypted roomEncrypted(JsonObject var1);

    @InheritConfiguration
    @Mapping(expression="java(roomMessageContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public RoomMessage roomMessage(JsonObject var1);

    @Mapping(expression="java(roomMessageFeedbackContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public RoomMessageFeedback roomMessageFeedback(JsonObject var1);

    @InheritConfiguration
    @Mapping(expression="java(roomRedactionContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public RoomRedaction roomRedaction(JsonObject var1);

    @InheritConfiguration
    @Mapping(expression="java(stickerContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public Sticker sticker(JsonObject var1);

    @InheritConfiguration
    @Mapping(expression="java(toString(jsonObject, \"state_key\"))", target="stateKey")
    public void stateEvent(JsonObject var1, @MappingTarget StateEvent var2);

    @InheritConfiguration(name="stateEvent")
    @Mappings(value={@Mapping(expression="java(roomAliasesContent(jsonObject.getJsonObject(\"content\")))", target="content"), @Mapping(expression="java(roomAliasesContent(jsonObject.getJsonObject(\"prev_content\")))", target="prevContent")})
    public RoomAliases roomAliases(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mappings(value={@Mapping(expression="java(roomAvatarContent(jsonObject.getJsonObject(\"content\")))", target="content"), @Mapping(expression="java(roomAvatarContent(jsonObject.getJsonObject(\"prev_content\")))", target="prevContent")})
    public RoomAvatar roomAvatar(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mappings(value={@Mapping(expression="java(roomCanonicalAliasContent(jsonObject.getJsonObject(\"content\")))", target="content"), @Mapping(expression="java(roomCanonicalAliasContent(jsonObject.getJsonObject(\"prev_content\")))", target="prevContent")})
    public RoomCanonicalAlias roomCanonicalAlias(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mappings(value={@Mapping(expression="java(roomCreateContent(jsonObject.getJsonObject(\"content\")))", target="content"), @Mapping(expression="java(roomCreateContent(jsonObject.getJsonObject(\"prev_content\")))", target="prevContent")})
    public RoomCreate roomCreate(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mappings(value={@Mapping(expression="java(roomEncryptionContent(jsonObject.getJsonObject(\"content\")))", target="content"), @Mapping(expression="java(roomEncryptionContent(jsonObject.getJsonObject(\"prev_content\")))", target="prevContent")})
    public RoomEncryption roomEncryption(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mappings(value={@Mapping(expression="java(roomGuestAccessContent(jsonObject.getJsonObject(\"content\")))", target="content"), @Mapping(expression="java(roomGuestAccessContent(jsonObject.getJsonObject(\"prev_content\")))", target="prevContent")})
    public RoomGuestAccess roomGuestAccess(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mappings(value={@Mapping(expression="java(roomHistoryVisibilityContent(jsonObject.getJsonObject(\"content\")))", target="content"), @Mapping(expression="java(roomHistoryVisibilityContent(jsonObject.getJsonObject(\"prev_content\")))", target="prevContent")})
    public RoomHistoryVisibility roomHistoryVisibility(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mappings(value={@Mapping(expression="java(roomJoinRulesContent(jsonObject.getJsonObject(\"content\")))", target="content"), @Mapping(expression="java(roomJoinRulesContent(jsonObject.getJsonObject(\"prev_content\")))", target="prevContent")})
    public RoomJoinRules roomJoinRules(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mappings(value={@Mapping(expression="java(roomMemberContent(jsonObject.getJsonObject(\"content\")))", target="content"), @Mapping(expression="java(roomMemberContent(jsonObject.getJsonObject(\"prev_content\")))", target="prevContent")})
    public RoomMember roomMember(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mappings(value={@Mapping(expression="java(roomNameContent(jsonObject.getJsonObject(\"content\")))", target="content"), @Mapping(expression="java(roomNameContent(jsonObject.getJsonObject(\"prev_content\")))", target="prevContent")})
    public RoomName roomName(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mappings(value={@Mapping(expression="java(roomPinnedContent(jsonObject.getJsonObject(\"content\")))", target="content"), @Mapping(expression="java(roomPinnedContent(jsonObject.getJsonObject(\"prev_content\")))", target="prevContent")})
    public RoomPinned roomPinned(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mappings(value={@Mapping(expression="java(roomPowerLevelsContent(jsonObject.getJsonObject(\"content\")))", target="content"), @Mapping(expression="java(roomPowerLevelsContent(jsonObject.getJsonObject(\"prev_content\")))", target="prevContent")})
    public RoomPowerLevels roomPowerLevels(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mappings(value={@Mapping(expression="java(roomServerAclContent(jsonObject.getJsonObject(\"content\")))", target="content"), @Mapping(expression="java(roomServerAclContent(jsonObject.getJsonObject(\"prev_content\")))", target="prevContent")})
    public RoomServerAcl roomServerAcl(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mappings(value={@Mapping(expression="java(roomThirdPartyInviteContent(jsonObject.getJsonObject(\"content\")))", target="content"), @Mapping(expression="java(roomThirdPartyInviteContent(jsonObject.getJsonObject(\"prev_content\")))", target="prevContent")})
    public RoomThirdPartyInvite roomThirdPartyInvite(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mappings(value={@Mapping(expression="java(tombstoneContent(jsonObject.getJsonObject(\"content\")))", target="content"), @Mapping(expression="java(tombstoneContent(jsonObject.getJsonObject(\"prev_content\")))", target="prevContent")})
    public RoomTombstone roomTombstone(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mappings(value={@Mapping(expression="java(roomTopicContent(jsonObject.getJsonObject(\"content\")))", target="content"), @Mapping(expression="java(roomTopicContent(jsonObject.getJsonObject(\"prev_content\")))", target="prevContent")})
    public RoomTopic roomTopic(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mapping(expression="java(policyRuleUserContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public PolicyRuleUser policyRuleUser(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mapping(expression="java(policyRuleRoomContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public PolicyRuleRoom policyRuleRoom(JsonObject var1);

    @InheritConfiguration(name="stateEvent")
    @Mapping(expression="java(policyRuleServerContent(jsonObject.getJsonObject(\"content\")))", target="content")
    public PolicyRuleServer policyRuleServer(JsonObject var1);

    default public DirectContent directContent(JsonObject jsonObject) {
        if (this.isNull((JsonValue)jsonObject)) {
            return null;
        }
        DirectContent directContent = new DirectContent();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (this.isNull((JsonValue)entry.getValue())) continue;
            directContent.put((Object)((String)entry.getKey()), this.toStringArray(((JsonValue)entry.getValue()).asJsonArray()));
        }
        return directContent;
    }

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"algorithm\"))", target="algorithm"), @Mapping(expression="java(toString(jsonObject, \"room_id\"))", target="roomId"), @Mapping(expression="java(toString(jsonObject, \"sender_key\"))", target="senderKey"), @Mapping(expression="java(toString(jsonObject, \"session_id\"))", target="sessionId"), @Mapping(expression="java(toString(jsonObject, \"session_key\"))", target="sessionKey"), @Mapping(expression="java(toString(jsonObject, \"sender_claimed_ed25519_key\"))", target="senderClaimedEd25519Key"), @Mapping(expression="java(toStringArray(jsonObject, \"forwarding_curve25519_key_chain\"))", target="forwardingCurve25519KeyChain")})
    public ForwardedRoomKeyContent forwardedRoomKeyContent(JsonObject var1);

    @Mapping(expression="java(toString(jsonObject, \"event_id\"))", target="eventId")
    public FullyReadContent fullyReadContent(JsonObject var1);

    default public IgnoredUserListContent ignoredUserListContent(JsonObject jsonObject) {
        if (this.isNull((JsonValue)jsonObject)) {
            return null;
        }
        IgnoredUserListContent ignoredUserListContent = new IgnoredUserListContent();
        if (!this.isNull(jsonObject, "ignored_users")) {
            HashMap<String, Object> ignoredUsers = new HashMap<String, Object>();
            for (Map.Entry entry : jsonObject.getJsonObject("ignored_users").entrySet()) {
                ignoredUsers.put((String)entry.getKey(), EMPTY);
            }
            ignoredUserListContent.setIgnoredUsers(ignoredUsers);
        }
        return ignoredUserListContent;
    }

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"transaction_id\"))", target="transactionId"), @Mapping(expression="java(toString(jsonObject, \"method\"))", target="method"), @Mapping(expression="java(toString(jsonObject, \"key_agreement_protocol\"))", target="keyAgreementProtocol"), @Mapping(expression="java(toString(jsonObject, \"hash\"))", target="hash"), @Mapping(expression="java(toString(jsonObject, \"message_authentication_code\"))", target="messageAuthenticationCode"), @Mapping(expression="java(toString(jsonObject, \"short_authentication_string\"))", target="shortAuthenticationString"), @Mapping(expression="java(toString(jsonObject, \"commitment\"))", target="commitment")})
    public KeyVerificationAcceptContent keyVerificationAcceptContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"transaction_id\"))", target="transactionId"), @Mapping(expression="java(toString(jsonObject, \"reason\"))", target="reason"), @Mapping(expression="java(toString(jsonObject, \"code\"))", target="code")})
    public KeyVerificationCancelContent keyVerificationCancelContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"transaction_id\"))", target="transactionId"), @Mapping(expression="java(toString(jsonObject, \"key\"))", target="key")})
    public KeyVerificationKeyContent keyVerificationKeyContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"transaction_id\"))", target="transactionId"), @Mapping(expression="java(toStringMap(jsonObject, \"mac\"))", target="mac"), @Mapping(expression="java(toString(jsonObject, \"keys\"))", target="keys")})
    public KeyVerificationMacContent keyVerificationMacContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"from_device\"))", target="fromDevice"), @Mapping(expression="java(toString(jsonObject, \"transaction_id\"))", target="transactionId"), @Mapping(expression="java(toStringArray(jsonObject, \"methods\"))", target="methods"), @Mapping(expression="java(toLong(jsonObject, \"timestamp\"))", target="timestamp")})
    public KeyVerificationRequestContent keyVerificationRequestContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"from_device\"))", target="fromDevice"), @Mapping(expression="java(toString(jsonObject, \"transaction_id\"))", target="transactionId"), @Mapping(expression="java(toString(jsonObject, \"method\"))", target="method"), @Mapping(expression="java(toString(jsonObject, \"next_method\"))", target="nextMethod"), @Mapping(expression="java(toStringArray(jsonObject, \"key_agreement_protocol\"))", target="keyAgreementProtocol"), @Mapping(expression="java(toStringArray(jsonObject, \"hashes\"))", target="hashes"), @Mapping(expression="java(toStringArray(jsonObject, \"message_authentication_codes\"))", target="messageAuthenticationCodes"), @Mapping(expression="java(toStringArray(jsonObject, \"short_authentication_string\"))", target="shortAuthenticationString")})
    public KeyVerificationStartContent keyVerificationStartContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"avatar_url\"))", target="avatarUrl"), @Mapping(expression="java(toString(jsonObject, \"displayname\"))", target="displayName"), @Mapping(expression="java(toLong(jsonObject, \"last_active_ago\"))", target="lastActiveAgo"), @Mapping(expression="java(toString(jsonObject, \"presence\"))", target="presence"), @Mapping(expression="java(toBoolean(jsonObject, \"currently_active\"))", target="currentlyActive"), @Mapping(expression="java(toString(jsonObject, \"status_msg\"))", target="statusMsg")})
    public PresenceContent presenceContent(JsonObject var1);

    @Mapping(expression="java(ruleset(jsonObject.getJsonObject(\"global\")))", target="global")
    public PushRulesContent pushRulesContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(pushRuleArray(jsonObject.getJsonArray(\"content\")))", target="content"), @Mapping(expression="java(pushRuleArray(jsonObject.getJsonArray(\"override\")))", target="override"), @Mapping(expression="java(pushRuleArray(jsonObject.getJsonArray(\"room\")))", target="room"), @Mapping(expression="java(pushRuleArray(jsonObject.getJsonArray(\"sender\")))", target="sender"), @Mapping(expression="java(pushRuleArray(jsonObject.getJsonArray(\"underride\")))", target="underride")})
    public Ruleset ruleset(JsonObject var1);

    public List<PushRule> pushRuleArray(JsonArray var1);

    @Mappings(value={@Mapping(expression="java(actions(jsonObject))", target="actions"), @Mapping(expression="java(toBoolean(jsonObject, \"default\"))", target="defaultRule"), @Mapping(expression="java(toBoolean(jsonObject, \"enabled\"))", target="enabled"), @Mapping(expression="java(toString(jsonObject, \"rule_id\"))", target="ruleId"), @Mapping(expression="java(conditions(jsonObject.getJsonArray(\"conditions\")))", target="conditions"), @Mapping(expression="java(toString(jsonObject, \"pattern\"))", target="pattern")})
    public PushRule pushRule(JsonObject var1);

    default public List<Object> actions(JsonObject jsonObject) {
        if (this.isNull(jsonObject, "actions")) {
            return null;
        }
        return jsonObject.getJsonArray("actions").stream().map(action -> {
            switch (action.getValueType()) {
                case STRING: {
                    return this.toString((JsonValue)action);
                }
                case OBJECT: {
                    return this.toStringMap(action.asJsonObject());
                }
            }
            return action.toString();
        }).collect(Collectors.toList());
    }

    public List<PushCondition> conditions(JsonArray var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"kind\"))", target="kind"), @Mapping(expression="java(toString(jsonObject, \"key\"))", target="key"), @Mapping(expression="java(toString(jsonObject, \"pattern\"))", target="pattern"), @Mapping(expression="java(toString(jsonObject, \"is\"))", target="is")})
    public PushCondition pushCondition(JsonObject var1);

    default public ReceiptContent receiptContent(JsonObject jsonObject) {
        if (this.isNull((JsonValue)jsonObject)) {
            return null;
        }
        ReceiptContent receiptContent = new ReceiptContent();
        for (Map.Entry entry : jsonObject.entrySet()) {
            receiptContent.put((Object)((String)entry.getKey()), (Object)this.receiptInfo(((JsonValue)entry.getValue()).asJsonObject()));
        }
        return receiptContent;
    }

    default public ReceiptInfo receiptInfo(JsonObject jsonObject) {
        if (this.isNull((JsonValue)jsonObject)) {
            return null;
        }
        ReceiptInfo receiptInfo = new ReceiptInfo();
        if (!this.isNull(jsonObject, "m.read")) {
            HashMap<String, ReceiptTs> read = new HashMap<String, ReceiptTs>();
            for (Map.Entry entry : jsonObject.getJsonObject("m.read").entrySet()) {
                ReceiptTs receiptTs;
                JsonValue entryValue = (JsonValue)entry.getValue();
                if (entryValue.getValueType() == JsonValue.ValueType.STRING) {
                    String serializedObject = entryValue.toString();
                    String preparedString = serializedObject.substring(1, serializedObject.length() - 1).replaceAll("\\\\", "");
                    receiptTs = (ReceiptTs)JSONB.fromJson(preparedString, ReceiptTs.class);
                } else {
                    receiptTs = this.receiptTs(entryValue.asJsonObject());
                }
                read.put((String)entry.getKey(), receiptTs);
            }
            receiptInfo.setRead(read);
        }
        return receiptInfo;
    }

    @Mapping(expression="java(toLong(jsonObject, \"ts\"))", target="ts")
    public ReceiptTs receiptTs(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"algorithm\"))", target="algorithm"), @Mapping(expression="java(toString(jsonObject, \"room_id\"))", target="roomId"), @Mapping(expression="java(toString(jsonObject, \"session_id\"))", target="sessionId"), @Mapping(expression="java(toString(jsonObject, \"session_key\"))", target="sessionKey")})
    public RoomKeyContent roomKeyContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(requestKeyInfo(jsonObject.getJsonObject(\"body\")))", target="body"), @Mapping(expression="java(toString(jsonObject, \"action\"))", target="action"), @Mapping(expression="java(toString(jsonObject, \"requesting_device_id\"))", target="requestingDeviceId"), @Mapping(expression="java(toString(jsonObject, \"request_id\"))", target="requestId")})
    public RoomKeyRequestContent roomKeyRequestContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"algorithm\"))", target="algorithm"), @Mapping(expression="java(toString(jsonObject, \"room_id\"))", target="roomId"), @Mapping(expression="java(toString(jsonObject, \"sender_key\"))", target="senderKey"), @Mapping(expression="java(toString(jsonObject, \"session_id\"))", target="sessionId")})
    public RequestedKeyInfo requestKeyInfo(JsonObject var1);

    default public TagContent tagContent(JsonObject jsonObject) {
        if (this.isNull((JsonValue)jsonObject)) {
            return null;
        }
        TagContent tagContent = new TagContent();
        if (!this.isNull(jsonObject, "tags")) {
            HashMap<String, TagInfo> tags = new HashMap<String, TagInfo>();
            for (Map.Entry entry : jsonObject.getJsonObject("tags").entrySet()) {
                tags.put((String)entry.getKey(), this.tagInfo(((JsonValue)entry.getValue()).asJsonObject()));
            }
            tagContent.setTags(tags);
        }
        return tagContent;
    }

    @Mapping(expression="java(toLong(jsonObject, \"order\"))", target="order")
    public TagInfo tagInfo(JsonObject var1);

    @Mapping(expression="java(toStringArray(jsonObject, \"user_ids\"))", target="userIds")
    public TypingContent typingContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"call_id\"))", target="callId"), @Mapping(expression="java(answer(jsonObject.getJsonObject(\"answer\")))", target="answer"), @Mapping(expression="java(toLong(jsonObject, \"version\"))", target="version")})
    public CallAnswerContent callAnswerContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"type\"))", target="type"), @Mapping(expression="java(toString(jsonObject, \"sdp\"))", target="sdp")})
    public Answer answer(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"call_id\"))", target="callId"), @Mapping(expression="java(candidates(jsonObject.getJsonArray(\"candidates\")))", target="candidates"), @Mapping(expression="java(toLong(jsonObject, \"version\"))", target="version")})
    public CallCandidatesContent callCandidatesContent(JsonObject var1);

    public List<Candidate> candidates(JsonArray var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"sdpMid\"))", target="sdpMid"), @Mapping(expression="java(toLong(jsonObject, \"sdpMLineIndex\"))", target="sdpMLineIndex"), @Mapping(expression="java(toString(jsonObject, \"candidate\"))", target="candidate")})
    public Candidate candidate(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"call_id\"))", target="callId"), @Mapping(expression="java(toLong(jsonObject, \"version\"))", target="version"), @Mapping(expression="java(toString(jsonObject, \"reason\"))", target="reason")})
    public CallHangupContent callHangupContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"call_id\"))", target="callId"), @Mapping(expression="java(offer(jsonObject.getJsonObject(\"offer\")))", target="offer"), @Mapping(expression="java(toLong(jsonObject, \"version\"))", target="version"), @Mapping(expression="java(toLong(jsonObject, \"lifetime\"))", target="lifetime")})
    public CallInviteContent callInviteContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"type\"))", target="type"), @Mapping(expression="java(toString(jsonObject, \"sdp\"))", target="sdp")})
    public Offer offer(JsonObject var1);

    default public RoomEncryptedContent roomEncryptedContent(JsonObject jsonObject) {
        OlmEncryptedContent roomEncryptedContent;
        String algorithm;
        if (this.isNull((JsonValue)jsonObject)) {
            return null;
        }
        switch (algorithm = jsonObject.getString("algorithm")) {
            case "m.olm.v1.curve25519-aes-sha2": {
                roomEncryptedContent = this.olmEncryptedContent(jsonObject);
                break;
            }
            case "m.megolm.v1.aes-sha2": {
                roomEncryptedContent = this.megolmEncryptedContent(jsonObject);
                break;
            }
            default: {
                roomEncryptedContent = this.rawEncryptedContent(jsonObject, algorithm);
            }
        }
        roomEncryptedContent.setSenderKey(this.toString(jsonObject, "sender_key"));
        roomEncryptedContent.setDeviceId(this.toString(jsonObject, "device_id"));
        roomEncryptedContent.setSessionId(this.toString(jsonObject, "session_id"));
        return roomEncryptedContent;
    }

    default public OlmEncryptedContent olmEncryptedContent(JsonObject jsonObject) {
        OlmEncryptedContent olmEncryptedContent = new OlmEncryptedContent();
        if (!this.isNull(jsonObject, "ciphertext")) {
            HashMap<String, CiphertextInfo> ciphertext = new HashMap<String, CiphertextInfo>();
            for (Map.Entry entry : jsonObject.getJsonObject("ciphertext").entrySet()) {
                ciphertext.put((String)entry.getKey(), this.ciphertextInfo(((JsonValue)entry.getValue()).asJsonObject()));
            }
            olmEncryptedContent.setCiphertext(ciphertext);
        }
        return olmEncryptedContent;
    }

    @Mapping(expression="java(toString(jsonObject, \"ciphertext\"))", target="ciphertext")
    public MegolmEncryptedContent megolmEncryptedContent(JsonObject var1);

    default public RawEncryptedContent rawEncryptedContent(JsonObject jsonObject, String algorithhm) {
        return new RawEncryptedContent(this.toRawMap(jsonObject), algorithhm);
    }

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"body\"))", target="body"), @Mapping(expression="java(toLong(jsonObject, \"type\"))", target="type")})
    public CiphertextInfo ciphertextInfo(JsonObject var1);

    default public RoomMessageContent roomMessageContent(JsonObject jsonObject) {
        Audio roomMessageContent;
        String msgtype;
        if (this.isNull((JsonValue)jsonObject)) {
            return null;
        }
        if (this.isNull(jsonObject, "msgtype")) {
            return this.rawMessageContent(jsonObject, null);
        }
        switch (msgtype = jsonObject.getString("msgtype")) {
            case "m.audio": {
                roomMessageContent = this.audio(jsonObject);
                break;
            }
            case "m.emote": {
                roomMessageContent = this.emote(jsonObject);
                break;
            }
            case "m.file": {
                roomMessageContent = this.file(jsonObject);
                break;
            }
            case "m.image": {
                roomMessageContent = this.image(jsonObject);
                break;
            }
            case "m.location": {
                roomMessageContent = this.location(jsonObject);
                break;
            }
            case "m.notice": {
                roomMessageContent = this.notice(jsonObject);
                break;
            }
            case "m.server_notice": {
                roomMessageContent = this.serverNotice(jsonObject);
                break;
            }
            case "m.text": {
                roomMessageContent = this.text(jsonObject);
                break;
            }
            case "m.video": {
                roomMessageContent = this.video(jsonObject);
                break;
            }
            default: {
                roomMessageContent = this.rawMessageContent(jsonObject, msgtype);
            }
        }
        roomMessageContent.setBody(this.toString(jsonObject, "body"));
        roomMessageContent.setRelatesTo(this.relates(jsonObject));
        return roomMessageContent;
    }

    default public RawMessageContent rawMessageContent(JsonObject jsonObject, String msgtype) {
        return new RawMessageContent(this.toRawMap(jsonObject), msgtype);
    }

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"format\"))", target="format"), @Mapping(expression="java(toString(jsonObject, \"formatted_body\"))", target="formattedBody")})
    public void formattedBody(JsonObject var1, @MappingTarget FormattedBody var2);

    @Mappings(value={@Mapping(expression="java(audioInfo(jsonObject.getJsonObject(\"duration\")))", target="info"), @Mapping(expression="java(toString(jsonObject, \"url\"))", target="url"), @Mapping(expression="java(encryptedFile(jsonObject.getJsonObject(\"file\")))", target="file")})
    public Audio audio(JsonObject var1);

    @InheritConfiguration
    public Emote emote(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"filename\"))", target="filename"), @Mapping(expression="java(fileInfo(jsonObject.getJsonObject(\"info\")))", target="info"), @Mapping(expression="java(toString(jsonObject, \"url\"))", target="url"), @Mapping(expression="java(encryptedFile(jsonObject.getJsonObject(\"file\")))", target="file")})
    public File file(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(imageInfo(jsonObject.getJsonObject(\"info\")))", target="info"), @Mapping(expression="java(toString(jsonObject, \"url\"))", target="url"), @Mapping(expression="java(encryptedFile(jsonObject.getJsonObject(\"file\")))", target="file")})
    public Image image(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(locationInfo(jsonObject.getJsonObject(\"info\")))", target="info"), @Mapping(expression="java(toString(jsonObject, \"geo_uri\"))", target="geoUri")})
    public Location location(JsonObject var1);

    @InheritConfiguration
    public Notice notice(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"server_notice_type\"))", target="serverNoticeType"), @Mapping(expression="java(toString(jsonObject, \"admin_contact\"))", target="adminContact"), @Mapping(expression="java(toString(jsonObject, \"limit_type\"))", target="limitType")})
    public ServerNotice serverNotice(JsonObject var1);

    @InheritConfiguration
    public Text text(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(videoInfo(jsonObject.getJsonObject(\"info\")))", target="info"), @Mapping(expression="java(toString(jsonObject, \"url\"))", target="url"), @Mapping(expression="java(encryptedFile(jsonObject.getJsonObject(\"file\")))", target="file")})
    public Video video(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toLong(jsonObject, \"duration\"))", target="duration"), @Mapping(expression="java(toString(jsonObject, \"mimetype\"))", target="mimetype"), @Mapping(expression="java(toLong(jsonObject, \"size\"))", target="size")})
    public AudioInfo audioInfo(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"thumbnail_url\"))", target="thumbnailUrl"), @Mapping(expression="java(encryptedFile(jsonObject.getJsonObject(\"thumbnail_file\")))", target="thumbnailFile"), @Mapping(expression="java(thumbnailInfo(jsonObject.getJsonObject(\"thumbnail_info\")))", target="thumbnailInfo")})
    public LocationInfo locationInfo(JsonObject var1);

    @InheritConfiguration
    @Mappings(value={@Mapping(expression="java(toLong(jsonObject, \"h\"))", target="height"), @Mapping(expression="java(toLong(jsonObject, \"w\"))", target="width"), @Mapping(expression="java(toLong(jsonObject, \"duration\"))", target="duration")})
    public VideoInfo videoInfo(JsonObject var1);

    @Mapping(expression="java(reply(jsonObject.getJsonObject(\"m.in_reply_to\")))", target="inReplyTo")
    public Relates relates(JsonObject var1);

    @Mapping(expression="java(toString(jsonObject, \"event_id\"))", target="eventId")
    public Reply reply(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"target_event_id\"))", target="targetEventId"), @Mapping(expression="java(toString(jsonObject, \"type\"))", target="type")})
    public RoomMessageFeedbackContent roomMessageFeedbackContent(JsonObject var1);

    @Mapping(expression="java(toString(jsonObject, \"reason\"))", target="reason")
    public RoomRedactionContent roomRedactionContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"body\"))", target="body"), @Mapping(expression="java(imageInfo(jsonObject.getJsonObject(\"info\")))", target="info"), @Mapping(expression="java(toString(jsonObject, \"url\"))", target="url")})
    public StickerContent stickerContent(JsonObject var1);

    @InheritConfiguration
    @Mappings(value={@Mapping(expression="java(toLong(jsonObject, \"h\"))", target="height"), @Mapping(expression="java(toLong(jsonObject, \"w\"))", target="width")})
    public ImageInfo imageInfo(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"mimetype\"))", target="mimetype"), @Mapping(expression="java(toLong(jsonObject, \"size\"))", target="size"), @Mapping(expression="java(toString(jsonObject, \"thumbnail_url\"))", target="thumbnailUrl"), @Mapping(expression="java(encryptedFile(jsonObject.getJsonObject(\"thumbnail_file\")))", target="thumbnailFile"), @Mapping(expression="java(thumbnailInfo(jsonObject.getJsonObject(\"thumbnail_info\")))", target="thumbnailInfo")})
    public FileInfo fileInfo(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"url\"))", target="url"), @Mapping(expression="java(jwk(jsonObject.getJsonObject(\"key\")))", target="key"), @Mapping(expression="java(toString(jsonObject, \"iv\"))", target="iv"), @Mapping(expression="java(toStringMap(jsonObject, \"hashes\"))", target="hashes"), @Mapping(expression="java(toString(jsonObject, \"v\"))", target="version")})
    public EncryptedFile encryptedFile(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"key\"))", target="key"), @Mapping(expression="java(toStringArray(jsonObject, \"key_opts\"))", target="keyOpts"), @Mapping(expression="java(toString(jsonObject, \"alg\"))", target="alg"), @Mapping(expression="java(toString(jsonObject, \"k\"))", target="encodedKey"), @Mapping(expression="java(toBoolean(jsonObject, \"ext\"))", target="ext")})
    public JWK jwk(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toLong(jsonObject, \"h\"))", target="height"), @Mapping(expression="java(toLong(jsonObject, \"w\"))", target="width"), @Mapping(expression="java(toString(jsonObject, \"mimetype\"))", target="mimetype"), @Mapping(expression="java(toLong(jsonObject, \"size\"))", target="size")})
    public ThumbnailInfo thumbnailInfo(JsonObject var1);

    @Mapping(expression="java(toStringArray(jsonObject, \"aliases\"))", target="aliases")
    public RoomAliasesContent roomAliasesContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"url\"))", target="url"), @Mapping(expression="java(imageInfo(jsonObject.getJsonObject(\"info\")))", target="info")})
    public RoomAvatarContent roomAvatarContent(JsonObject var1);

    @Mapping(expression="java(toString(jsonObject, \"alias\"))", target="alias")
    public RoomCanonicalAliasContent roomCanonicalAliasContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"creator\"))", target="creator"), @Mapping(expression="java(toBoolean(jsonObject, \"m.federate\"))", target="federate"), @Mapping(expression="java(toString(jsonObject, \"room_version\"))", target="roomVersion"), @Mapping(expression="java(previousRoom(jsonObject.getJsonObject(\"predecessor\")))", target="predecessor")})
    public RoomCreateContent roomCreateContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"room_id\"))", target="roomId"), @Mapping(expression="java(toString(jsonObject, \"event_id\"))", target="eventId")})
    public PreviousRoom previousRoom(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"algorithm\"))", target="algorithm"), @Mapping(expression="java(toLong(jsonObject, \"rotation_period_ms\"))", target="rotationPeriodMs"), @Mapping(expression="java(toLong(jsonObject, \"rotation_period_msgs\"))", target="rotationPeriodMsgs")})
    public RoomEncryptionContent roomEncryptionContent(JsonObject var1);

    @Mapping(expression="java(toString(jsonObject, \"guest_access\"))", target="guestAccess")
    public RoomGuestAccessContent roomGuestAccessContent(JsonObject var1);

    @Mapping(expression="java(toString(jsonObject, \"history_visibility\"))", target="historyVisibility")
    public RoomHistoryVisibilityContent roomHistoryVisibilityContent(JsonObject var1);

    @Mapping(expression="java(toString(jsonObject, \"join_rule\"))", target="joinRule")
    public RoomJoinRulesContent roomJoinRulesContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"avatar_url\"))", target="avatarUrl"), @Mapping(expression="java(toString(jsonObject, \"displayname\"))", target="displayName"), @Mapping(expression="java(toString(jsonObject, \"membership\"))", target="membership"), @Mapping(expression="java(toBoolean(jsonObject, \"is_direct\"))", target="direct"), @Mapping(expression="java(invite(jsonObject.getJsonObject(\"third_party_invite\")))", target="thirdPartyInvite"), @Mapping(expression="java(unsigned(jsonObject.getJsonObject(\"third_party_invite\"), \"m.room.member\"))", target="unsigned")})
    public RoomMemberContent roomMemberContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"display_name\"))", target="displayName"), @Mapping(expression="java(signed(jsonObject.getJsonObject(\"signed\")))", target="signed")})
    public Invite invite(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"mxid\"))", target="mxid"), @Mapping(expression="java(toString(jsonObject, \"token\"))", target="token"), @Mapping(expression="java(signatures(jsonObject.getJsonObject(\"signatures\")))", target="signatures")})
    public Signed signed(JsonObject var1);

    default public Map<String, Map<String, String>> signatures(JsonObject jsonObject) {
        if (this.isNull((JsonValue)jsonObject)) {
            return null;
        }
        HashMap<String, Map<String, String>> signatures = new HashMap<String, Map<String, String>>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            signatures.put((String)entry.getKey(), this.toStringMap(((JsonValue)entry.getValue()).asJsonObject()));
        }
        return signatures;
    }

    @Mapping(expression="java(toString(jsonObject, \"name\"))", target="name")
    public RoomNameContent roomNameContent(JsonObject var1);

    @Mapping(expression="java(toStringArray(jsonObject, \"pinned\"))", target="pinned")
    public RoomPinnedContent roomPinnedContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toByte(jsonObject, \"ban\"))", target="ban"), @Mapping(expression="java(toStringByteMap(jsonObject, \"events\"))", target="events"), @Mapping(expression="java(toByte(jsonObject, \"events_default\"))", target="eventsDefault"), @Mapping(expression="java(toByte(jsonObject, \"invite\"))", target="invite"), @Mapping(expression="java(toByte(jsonObject, \"kick\"))", target="kick"), @Mapping(expression="java(toByte(jsonObject, \"redact\"))", target="redact"), @Mapping(expression="java(toByte(jsonObject, \"state_default\"))", target="stateDefault"), @Mapping(expression="java(toStringByteMap(jsonObject, \"users\"))", target="users"), @Mapping(expression="java(toByte(jsonObject, \"users_default\"))", target="usersDefault"), @Mapping(expression="java(notificationPowerLevel(jsonObject.getJsonObject(\"notifications\")))", target="notifications")})
    public RoomPowerLevelsContent roomPowerLevelsContent(JsonObject var1);

    @Mapping(expression="java(toByte(jsonObject, \"room\"))", target="room")
    public NotificationPowerLevel notificationPowerLevel(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toBoolean(jsonObject, \"allow_ip_literals\"))", target="allowIpLiterals"), @Mapping(expression="java(toStringArray(jsonObject, \"allow\"))", target="allow"), @Mapping(expression="java(toStringArray(jsonObject, \"deny\"))", target="deny")})
    public RoomServerAclContent roomServerAclContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"display_name\"))", target="displayName"), @Mapping(expression="java(toString(jsonObject, \"key_validity_url\"))", target="keyValidityUrl"), @Mapping(expression="java(toString(jsonObject, \"public_key\"))", target="publicKey"), @Mapping(expression="java(publicKeysArray(jsonObject.getJsonArray(\"public_keys\")))", target="publicKeys")})
    public RoomThirdPartyInviteContent roomThirdPartyInviteContent(JsonObject var1);

    public List<PublicKeys> publicKeysArray(JsonArray var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"key_validity_url\"))", target="keyValidityUrl"), @Mapping(expression="java(toString(jsonObject, \"public_key\"))", target="publicKey")})
    public PublicKeys publicKeys(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"body\"))", target="body"), @Mapping(expression="java(toString(jsonObject, \"replacement_room\"))", target="replacementRoom")})
    public TombstoneContent tombstoneContent(JsonObject var1);

    @Mapping(expression="java(toString(jsonObject, \"topic\"))", target="topic")
    public RoomTopicContent roomTopicContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"entity\"))", target="entity"), @Mapping(expression="java(toString(jsonObject, \"recommendation\"))", target="recommendation"), @Mapping(expression="java(toString(jsonObject, \"reason\"))", target="reason")})
    public PolicyRuleUserContent policyRuleUserContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"entity\"))", target="entity"), @Mapping(expression="java(toString(jsonObject, \"recommendation\"))", target="recommendation"), @Mapping(expression="java(toString(jsonObject, \"reason\"))", target="reason")})
    public PolicyRuleRoomContent policyRuleRoomContent(JsonObject var1);

    @Mappings(value={@Mapping(expression="java(toString(jsonObject, \"entity\"))", target="entity"), @Mapping(expression="java(toString(jsonObject, \"recommendation\"))", target="recommendation"), @Mapping(expression="java(toString(jsonObject, \"reason\"))", target="reason")})
    public PolicyRuleServerContent policyRuleServerContent(JsonObject var1);

    public static class Util {
        public Event parse(JsonObject jsonObject) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (Map.Entry entry : jsonObject.entrySet()) {
                JsonValue value = (JsonValue)entry.getValue();
                Object object = value == null ? null : this.parse(value);
                props.put((String)entry.getKey(), object);
            }
            return new RawEvent(props, (String)props.get("type"));
        }

        public Object parse(JsonValue jsonValue) {
            if (jsonValue == null) {
                return null;
            }
            switch (jsonValue.getValueType()) {
                case NULL: {
                    return null;
                }
                case STRING: {
                    return ((JsonString)jsonValue).getString();
                }
                case NUMBER: {
                    return ((JsonNumber)jsonValue).longValue();
                }
                case ARRAY: {
                    return jsonValue.asJsonArray().stream().map(this::parse).collect(Collectors.toList());
                }
                case TRUE: {
                    return Boolean.TRUE;
                }
                case FALSE: {
                    return Boolean.FALSE;
                }
                case OBJECT: {
                    return this.parse(jsonValue.asJsonObject());
                }
            }
            return jsonValue.toString();
        }
    }
}

