/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.event.content;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="An event to indicate which servers are permitted to participate in the room. Server ACLs may allow or deny groups of hosts.")
public class RoomServerAclContent
implements EventContent {
    @Schema(name="allow_ip_literals", description="True to allow server names that are IP address literals. False to deny. Defaults to true if missing or otherwise not a boolean. This is strongly recommended to be set to false as servers running with IP literal names are strongly discouraged in order to require legitimate homeservers to be backed by a valid registered domain name.")
    @JsonbProperty(value="allow_ip_literals")
    private Boolean allowIpLiterals;
    @Schema(description="The server names to allow in the room, excluding any port information. Wildcards may be used to cover a wider range of hosts, where * matches zero or more characters and ? matches exactly one character. This defaults to an empty list when not provided, effectively disallowing every server.")
    private List<String> allow;
    @Schema(description="The server names to disallow in the room, excluding any port information. Wildcards may be used to cover a wider range of hosts, where * matches zero or more characters and ? matches exactly one character. This defaults to an empty list when not provided.")
    private List<String> deny;

    @JsonProperty(value="allow_ip_literals")
    public Boolean getAllowIpLiterals() {
        return this.allowIpLiterals;
    }

    public void setAllowIpLiterals(Boolean allowIpLiterals) {
        this.allowIpLiterals = allowIpLiterals;
    }

    public List<String> getAllow() {
        return this.allow;
    }

    public void setAllow(List<String> allow) {
        this.allow = allow;
    }

    public List<String> getDeny() {
        return this.deny;
    }

    public void setDeny(List<String> deny) {
        this.deny = deny;
    }
}

