/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.EventContent;
import io.github.ma1uta.matrix.events.nested.PublicKeys;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="Acts as an m.room.member invite event, where there isn't a target user_id to invite. This event contains a token and a public key whose private key must be used to sign the token. Any user who can present that signature may use this invitation to join the target room.")
public class RoomThirdPartyInvite
implements EventContent {
    @ApiModelProperty(name="display_name", value="A user-readable string which represents the user who has been invited. This should not contain the user's third party ID, as otherwise when the invite is accepted it would leak the association between the matrix ID and the third party ID.", required=true)
    @JsonProperty(value="display_name")
    private String displayName;
    @ApiModelProperty(name="key_validity_url", value="A URL which can be fetched, with querystring public_key=public_key, to validate whether the key has been revoked. The URL must return a JSON object containing a boolean property named 'valid'.", required=true)
    @JsonProperty(value="key_validity_url")
    private String keyValidityUrl;
    @ApiModelProperty(name="public_key", value="A base64-encoded ed25519 key with which token must be signed (though a signature from any entry in public_keys is also sufficient). This exists for backwards compatibility.", required=true)
    @JsonProperty(value="public_key")
    private String publicKey;
    @ApiModelProperty(name="public_keys", value="Keys with which the token may be signed.")
    @JsonProperty(value="public_keys")
    private List<PublicKeys> publicKeys;

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getKeyValidityUrl() {
        return this.keyValidityUrl;
    }

    public void setKeyValidityUrl(String keyValidityUrl) {
        this.keyValidityUrl = keyValidityUrl;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public List<PublicKeys> getPublicKeys() {
        return this.publicKeys;
    }

    public void setPublicKeys(List<PublicKeys> publicKeys) {
        this.publicKeys = publicKeys;
    }
}

