/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.EventContent;
import io.github.ma1uta.matrix.events.nested.Invite;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="Adjusts the membership state for a user in a room. It is preferable to use the membership APIs (/rooms/<room id>/invite etc) when performing membership actions rather than adjusting the state directly as there are a restricted set of valid transformations. For example, user A cannot force user B to join a room, and trying to force this state change directly will fail.")
public class RoomMember
implements EventContent {
    @ApiModelProperty(name="avatar_url", value="The avatar URL for this user, if any. This is added by the homeserver.")
    @JsonProperty(value="avatar_url")
    private String avatarUrl;
    @ApiModelProperty(value="The display name for this user, if any. This is added by the homeserver.")
    private String displayname;
    @ApiModelProperty(value="The membership state of the user.", required=true, allowableValues="invite, join, knock, leave, ban")
    private String membership;
    @ApiModelProperty(name="is_direct", value="Flag indicating if the room containing this event was created with the intention of being a direct chat. See Direct Messaging.")
    @JsonProperty(value="is_direct")
    private Boolean isDirect;
    @ApiModelProperty(name="third_party_invite", value="Third-party invites.")
    @JsonProperty(value="third_party_invite")
    private Invite thirdPartyInvite;

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public void setDisplayname(String displayname) {
        this.displayname = displayname;
    }

    public String getMembership() {
        return this.membership;
    }

    public void setMembership(String membership) {
        this.membership = membership;
    }

    public Boolean getDirect() {
        return this.isDirect;
    }

    public void setDirect(Boolean direct) {
        this.isDirect = direct;
    }

    public Invite getThirdPartyInvite() {
        return this.thirdPartyInvite;
    }

    public void setThirdPartyInvite(Invite thirdPartyInvite) {
        this.thirdPartyInvite = thirdPartyInvite;
    }
}

