/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.github.ma1uta.matrix.EventContent;
import io.github.ma1uta.matrix.StrippedState;
import io.github.ma1uta.matrix.Unsigned;
import io.github.ma1uta.matrix.jackson.EventDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="Event.")
@JsonDeserialize(using=EventDeserializer.class)
public class Event {
    @ApiModelProperty(value="The fields in this object will vary depending on the type of event. When interacting with the REST API, this is the HTTP body.")
    private EventContent content;
    @ApiModelProperty(value="The type of event. This SHOULD be namespaced similar to Java package naming conventions.", required=true)
    private String type;
    @ApiModelProperty(name="event_id", value="The globally unique event identifier.", required=true)
    @JsonProperty(value="event_id")
    private String eventId;
    @ApiModelProperty(name="room_id", value="The ID of the room associated with this event.", required=true)
    @JsonProperty(value="room_id")
    private String roomId;
    @ApiModelProperty(value="Contains the fully-qualified ID of the user who sent this event.", required=true)
    private String sender;
    @ApiModelProperty(name="origin_server_ts", value="Timestamp in milliseconds on originating homeserver when this event was sent.", required=true)
    @JsonProperty(value="origin_server_ts")
    private Long originServerTs;
    @ApiModelProperty(value="Contains optional extra information about the event.")
    private Unsigned unsigned;
    @ApiModelProperty(name="prev_content", value="The previous content for this event. If there is no previous content, this key will be missing.")
    @JsonProperty(value="prev_content")
    private EventContent prevContent;
    @ApiModelProperty(name="state_key", value=" A unique key which defines the overwriting semantics for this piece of room state. This value is often a zero-length string. The presence of this key makes this event a State Event. The key MUST NOT start with '_'.", required=true)
    @JsonProperty(value="state_key")
    private String stateKey;
    @ApiModelProperty(name="invite_room_state", value="This contains an array of StrippedState Events. These events provide information on a subset of state events such as the room name.")
    @JsonProperty(value="invite_room_state")
    private List<StrippedState> inviteRoomState;

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public EventContent getContent() {
        return this.content;
    }

    public void setContent(EventContent content) {
        this.content = content;
    }

    public Long getOriginServerTs() {
        return this.originServerTs;
    }

    public void setOriginServerTs(Long originServerTs) {
        this.originServerTs = originServerTs;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getStateKey() {
        return this.stateKey;
    }

    public void setStateKey(String stateKey) {
        this.stateKey = stateKey;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Unsigned getUnsigned() {
        return this.unsigned;
    }

    public void setUnsigned(Unsigned unsigned) {
        this.unsigned = unsigned;
    }

    public EventContent getPrevContent() {
        return this.prevContent;
    }

    public void setPrevContent(EventContent prevContent) {
        this.prevContent = prevContent;
    }

    public List<StrippedState> getInviteRoomState() {
        return this.inviteRoomState;
    }

    public void setInviteRoomState(List<StrippedState> inviteRoomState) {
        this.inviteRoomState = inviteRoomState;
    }

    public static class GuestAccess {
        public static final String CAN_JOIN = "can_join";
        public static final String FORBIDDEN = "forbidden";

        protected GuestAccess() {
        }
    }

    public static class Visibility {
        public static final String WORLD_READABLE = "world_readable";
        public static final String SHARED = "shared";
        public static final String INVITED = "invited";
        public static final String JOINED = "joined";

        protected Visibility() {
        }
    }

    public static class MembershipState {
        public static final String INVITE = "invite";
        public static final String JOIN = "join";
        public static final String LEAVE = "leave";
        public static final String BAN = "ban";
        public static final String KNOCK = "knock";

        protected MembershipState() {
        }
    }

    public static class MessageType {
        public static final String TEXT = "m.text";
        public static final String EMOTE = "m.emote";
        public static final String NOTICE = "m.notice";
        public static final String IMAGE = "m.image";
        public static final String FILE = "m.file";
        public static final String LOCATION = "m.location";
        public static final String VIDEO = "m.video";
        public static final String AUDIO = "m.audio";

        protected MessageType() {
        }
    }

    public static class EventType {
        public static final String ROOM_ALIASES = "m.room.aliases";
        public static final String ROOM_CANONICAL_ALIAS = "m.room.canonical_alias";
        public static final String ROOM_CREATE = "m.room.create";
        public static final String ROOM_JOIN_RULES = "m.room.join_rules";
        public static final String ROOM_MEMBER = "m.room.member";
        public static final String ROOM_POWER_LEVELS = "m.room.power_levels";
        public static final String ROOM_REDACTION = "m.room.redaction";
        public static final String ROOM_MESSAGE = "m.room.message";
        @Deprecated
        public static final String ROOM_MESSAGE_FEEDBACK = "m.room.message.feedback";
        public static final String ROOM_NAME = "m.room.name";
        public static final String ROOM_TOPIC = "m.room.topic";
        public static final String ROOM_AVATAR = "m.room.avatar";
        public static final String ROOM_PINNED_EVENTS = "m.room.pinned_events";
        public static final String CALL_INVITE = "m.call.invite";
        public static final String CALL_CANDIDATES = "m.call.candidates";
        public static final String CALL_ANSWER = "m.call.answer";
        public static final String CALL_HANGUP = "m.call.hangup";
        public static final String TYPING = "m.typing";
        public static final String RECEIPT = "m.receipt";
        public static final String PRESENCE = "m.presence";
        public static final String ROOM_HISTORY_VISIBILITY = "m.room.history_visibility";
        public static final String ROOM_THIRD_PARTY_INVITE = "m.room.third_party_invite";
        public static final String ROOM_GUEST_ACCESS = "m.room.guest_access";
        public static final String TAG = "m.tag";
        public static final String DIRECT = "m.direct";
        public static final String IGNORED_USER_LIST = "m.ignored_user_list";
        public static final String STICKER = "m.sticker";

        protected EventType() {
        }
    }
}

