/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.api.FilterApi;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AbstractMethods;
import io.github.ma1uta.matrix.client.model.filter.FilterData;
import io.github.ma1uta.matrix.client.model.filter.FilterResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class FilterMethods
extends AbstractMethods {
    public FilterMethods(RequestFactory factory, RequestParams defaultParams) {
        super(factory, defaultParams);
    }

    public CompletableFuture<FilterResponse> uploadFilter(FilterData filter) {
        Objects.requireNonNull(this.defaults().getUserId(), "UserId cannot be empty.");
        RequestParams params = this.defaults().clone().path("userId", this.defaults().getUserId());
        return this.factory().post(FilterApi.class, "uploadFilter", params, filter, FilterResponse.class);
    }

    public CompletableFuture<FilterData> getFilter(String filterId) {
        Objects.requireNonNull(this.defaults().getUserId(), "UserId cannot be empty.");
        Objects.requireNonNull(filterId, "FilterId cannot be empty.");
        RequestParams params = this.defaults().clone().path("userId", this.defaults().getUserId()).path("filterId", filterId);
        return this.factory().get(FilterApi.class, "getFilter", params, FilterData.class);
    }
}

