/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.sync;

public class SyncParams {
    private String filter;
    private String nextBatch;
    private boolean fullState = false;
    private Long timeout;
    private String presence;
    private boolean terminate = false;

    public SyncParams() {
    }

    public SyncParams(SyncParams origin) {
        this.filter = origin.getFilter();
        this.nextBatch = origin.getNextBatch();
        this.fullState = origin.isFullState();
        this.timeout = origin.getTimeout();
        this.presence = origin.getPresence();
    }

    public SyncParams(String filter, String nextBatch, boolean fullState, Long timeout, String presence) {
        this.filter = filter;
        this.nextBatch = nextBatch;
        this.fullState = fullState;
        this.timeout = timeout;
        this.presence = presence;
    }

    public void from(SyncParams syncParams) {
        this.setFilter(syncParams.getFilter());
        this.setNextBatch(syncParams.getNextBatch());
        this.setFullState(syncParams.isFullState());
        this.setTimeout(syncParams.getTimeout());
        this.setPresence(syncParams.getPresence());
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getNextBatch() {
        return this.nextBatch;
    }

    public void setNextBatch(String nextBatch) {
        this.nextBatch = nextBatch;
    }

    public boolean isFullState() {
        return this.fullState;
    }

    public void setFullState(boolean fullState) {
        this.fullState = fullState;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public String getPresence() {
        return this.presence;
    }

    public void setPresence(String presence) {
        this.presence = presence;
    }

    public boolean isTerminate() {
        return this.terminate;
    }

    public void setTerminate(boolean terminate) {
        this.terminate = terminate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String filter;
        private String nextBatch;
        private boolean fullState;
        private Long timeout;
        private String presence;

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder nextBatch(String nextBatch) {
            this.nextBatch = nextBatch;
            return this;
        }

        public Builder fullState(boolean fullState) {
            this.fullState = fullState;
            return this;
        }

        public Builder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder presence(String presence) {
            this.presence = presence;
            return this;
        }

        public SyncParams build() {
            return new SyncParams(this.filter, this.nextBatch, this.fullState, this.timeout, this.presence);
        }
    }
}

