/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.blocked;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.model.account.AuthenticationData;
import io.github.ma1uta.matrix.client.model.account.AvailableResponse;
import io.github.ma1uta.matrix.client.model.account.DeactivateRequest;
import io.github.ma1uta.matrix.client.model.account.DeactivateResponse;
import io.github.ma1uta.matrix.client.model.account.Delete3PidRequest;
import io.github.ma1uta.matrix.client.model.account.EmailRequestToken;
import io.github.ma1uta.matrix.client.model.account.MsisdnRequestToken;
import io.github.ma1uta.matrix.client.model.account.PasswordRequest;
import io.github.ma1uta.matrix.client.model.account.RegisterRequest;
import io.github.ma1uta.matrix.client.model.account.ThreePidRequest;
import io.github.ma1uta.matrix.client.model.account.ThreePidResponse;
import io.github.ma1uta.matrix.client.model.account.WhoamiResponse;
import io.github.ma1uta.matrix.client.model.auth.LoginResponse;
import io.github.ma1uta.matrix.client.rest.blocked.AccountApi;
import io.github.ma1uta.matrix.thirdpid.SessionResponse;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class AccountMethods {
    private final AccountApi accountApi;
    private final Function<LoginResponse, LoginResponse> afterLogin;

    public AccountMethods(RestClientBuilder restClientBuilder, Function<LoginResponse, LoginResponse> afterLogin) {
        this.accountApi = (AccountApi)restClientBuilder.build(AccountApi.class);
        this.afterLogin = afterLogin;
    }

    public LoginResponse register(RegisterRequest request) {
        LoginResponse response = this.accountApi.register("user", request);
        return this.afterLogin != null ? this.afterLogin.apply(response) : response;
    }

    public SessionResponse emailRequestToken(EmailRequestToken requestToken) {
        Objects.requireNonNull(requestToken.getClientSecret(), "Client secret cannot be empty.");
        Objects.requireNonNull(requestToken.getEmail(), "Email cannot be empty.");
        Objects.requireNonNull(requestToken.getSendAttempt(), "Send attempt cannot be empty.");
        return this.accountApi.emailRequestToken(requestToken);
    }

    public SessionResponse msisdnRequestToken(MsisdnRequestToken requestToken) {
        Objects.requireNonNull(requestToken.getClientSecret(), "Client secret cannot be empty.");
        Objects.requireNonNull(requestToken.getCountry(), "Country cannot be empty.");
        Objects.requireNonNull(requestToken.getPhoneNumber(), "Phone number cannot be empty.");
        Objects.requireNonNull(requestToken.getSendAttempt(), "Send attempt cannot be empty.");
        return this.accountApi.msisdnRequestToken(requestToken);
    }

    public EmptyResponse password(char[] password, AuthenticationData auth) {
        Objects.requireNonNull(password, "Password cannot be empty.");
        PasswordRequest request = new PasswordRequest();
        request.setNewPassword(password);
        request.setAuth(auth);
        return this.accountApi.password(request);
    }

    public SessionResponse passwordEmailRequestToken(EmailRequestToken requestToken) {
        Objects.requireNonNull(requestToken.getClientSecret(), "Client secret cannot be empty.");
        Objects.requireNonNull(requestToken.getEmail(), "Email cannot be empty.");
        Objects.requireNonNull(requestToken.getSendAttempt(), "Send attempt cannot be empty.");
        return this.accountApi.passwordEmailRequestToken(requestToken);
    }

    public SessionResponse passwordMsisdnRequestToken(MsisdnRequestToken requestToken) {
        Objects.requireNonNull(requestToken.getClientSecret(), "Client secret cannot be empty.");
        Objects.requireNonNull(requestToken.getCountry(), "Country cannot be empty.");
        Objects.requireNonNull(requestToken.getPhoneNumber(), "Phone number cannot be empty.");
        Objects.requireNonNull(requestToken.getSendAttempt(), "Send attempt cannot be empty.");
        return this.accountApi.passwordMsisdnRequestToken(requestToken);
    }

    public DeactivateResponse deactivate(AuthenticationData auth) {
        DeactivateRequest request = new DeactivateRequest();
        request.setAuth(auth);
        return this.accountApi.deactivate(request);
    }

    public AvailableResponse available(String username) {
        Objects.requireNonNull(username, "Username cannot be empty");
        return this.accountApi.available(username);
    }

    public ThreePidResponse getThreePid() {
        return this.accountApi.getThreePid();
    }

    public EmptyResponse updateThreePid(ThreePidRequest request) {
        String error = "Threepids cannot be empty.";
        Objects.requireNonNull(request.getThreePidCreds(), error);
        return this.accountApi.updateThreePid(request);
    }

    public DeactivateResponse deleteThreePid(String medium, String address) {
        Objects.requireNonNull(medium, "Medium cannot be empty.");
        Objects.requireNonNull(address, "Address cannot be empty.");
        Delete3PidRequest request = new Delete3PidRequest();
        request.setMedium(medium);
        request.setAddress(address);
        return this.accountApi.deleteThreePid(request);
    }

    public SessionResponse threePidEmailRequestToken(EmailRequestToken requestToken) {
        Objects.requireNonNull(requestToken.getClientSecret(), "Client secret cannot be empty.");
        Objects.requireNonNull(requestToken.getEmail(), "Email cannot be empty.");
        Objects.requireNonNull(requestToken.getSendAttempt(), "Send attempt cannot be empty.");
        return this.accountApi.threePidEmailRequestToken(requestToken);
    }

    public SessionResponse threePidMsisdnRequestToken(MsisdnRequestToken requestToken) {
        Objects.requireNonNull(requestToken.getClientSecret(), "Client secret cannot be empty.");
        Objects.requireNonNull(requestToken.getCountry(), "Country cannot be empty.");
        Objects.requireNonNull(requestToken.getPhoneNumber(), "Phone number cannot be empty.");
        Objects.requireNonNull(requestToken.getSendAttempt(), "Send attempt cannot be empty.");
        return this.accountApi.threePidMsisdnRequestToken(requestToken);
    }

    public WhoamiResponse whoami() {
        return this.accountApi.whoami();
    }
}

