/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.async;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.model.push.NotificationResponse;
import io.github.ma1uta.matrix.client.model.push.PushActions;
import io.github.ma1uta.matrix.client.model.push.PushEnable;
import io.github.ma1uta.matrix.client.model.push.PushRulesResponse;
import io.github.ma1uta.matrix.client.model.push.PushUpdateRequest;
import io.github.ma1uta.matrix.client.model.push.PushersRequest;
import io.github.ma1uta.matrix.client.model.push.PushersResponse;
import io.github.ma1uta.matrix.client.rest.async.PushApi;
import io.github.ma1uta.matrix.event.nested.PushRule;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class PushAsyncMethods {
    private final PushApi pushApi;

    public PushAsyncMethods(RestClientBuilder restClientBuilder) {
        this.pushApi = (PushApi)restClientBuilder.build(PushApi.class);
    }

    public CompletableFuture<PushersResponse> showPushers() {
        return this.pushApi.showPushers().toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> setPushers(PushersRequest request) {
        return this.pushApi.setPushers(request).toCompletableFuture();
    }

    public CompletableFuture<NotificationResponse> notifications(String from, String only, Long limit) {
        return this.pushApi.notifications(from, only, limit).toCompletableFuture();
    }

    public CompletableFuture<PushRulesResponse> pushRules() {
        return this.pushApi.pushRules().toCompletableFuture();
    }

    public CompletableFuture<PushRule> pushRule(String scope, String kind, String ruleId) {
        Objects.requireNonNull(scope, "Scope cannot be empty.");
        Objects.requireNonNull(kind, "Kind cannot be empty.");
        Objects.requireNonNull(ruleId, "RuleId cannot be empty.");
        return this.pushApi.pushRule(scope, kind, ruleId).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> deleteRule(String scope, String kind, String ruleId) {
        Objects.requireNonNull(scope, "Scope cannot be empty.");
        Objects.requireNonNull(kind, "Kind cannot be empty.");
        Objects.requireNonNull(ruleId, "RuleId cannot be empty.");
        return this.pushApi.deleteRule(scope, kind, ruleId).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> updateRule(String scope, String kind, String ruleId, String before, String after, PushUpdateRequest request) {
        Objects.requireNonNull(scope, "Scope cannot be empty.");
        Objects.requireNonNull(kind, "Kind cannot be empty.");
        Objects.requireNonNull(ruleId, "RuleId cannot be empty.");
        if (request.getActions() == null || request.getActions().isEmpty()) {
            throw new NullPointerException("Actions cannot be empty.");
        }
        return this.pushApi.updateRule(scope, kind, ruleId, before, after, request).toCompletableFuture();
    }

    public CompletableFuture<PushEnable> getEnabled(String scope, String kind, String ruleId) {
        Objects.requireNonNull(scope, "Scope cannot be empty.");
        Objects.requireNonNull(kind, "Kind cannot be empty.");
        Objects.requireNonNull(ruleId, "RuleId cannot be empty.");
        return this.pushApi.getEnabled(scope, kind, ruleId).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> setEnabled(String scope, String kind, String ruleId, boolean enabled) {
        Objects.requireNonNull(scope, "Scope cannot be empty.");
        Objects.requireNonNull(kind, "Kind cannot be empty.");
        Objects.requireNonNull(ruleId, "RuleId cannot be empty.");
        PushEnable request = new PushEnable();
        request.setEnabled(Boolean.valueOf(enabled));
        return this.pushApi.setEnabled(scope, kind, ruleId, request).toCompletableFuture();
    }

    public CompletableFuture<PushActions> getActions(String scope, String kind, String ruleId) {
        Objects.requireNonNull(scope, "Scope cannot be empty.");
        Objects.requireNonNull(kind, "Kind cannot be empty.");
        Objects.requireNonNull(ruleId, "RuleId cannot be empty.");
        return this.pushApi.getActions(scope, kind, ruleId).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> setActions(String scope, String kind, String ruleId, List<String> actions) {
        Objects.requireNonNull(scope, "Scope cannot be empty.");
        Objects.requireNonNull(kind, "Kind cannot be empty.");
        Objects.requireNonNull(ruleId, "RuleId cannot be empty.");
        PushActions request = new PushActions();
        request.setActions(actions);
        return this.pushApi.setActions(scope, kind, ruleId, request).toCompletableFuture();
    }
}

