/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.filter;

import io.github.ma1uta.matrix.client.filter.StreamHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingFilter.class);
    public static final String BEARER_PREFIX = "bearer ";
    public static final int BEARER_PREFIX_LENGTH = "bearer ".length();

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (!LOGGER.isInfoEnabled()) {
            return;
        }
        StringBuilder builder = new StringBuilder("\n------------- Request -------------\n");
        builder.append("  Method: ").append(requestContext.getMethod()).append("\n");
        builder.append("  URI: ").append(requestContext.getUri()).append("\n");
        builder.append("  Headers:\n");
        for (Map.Entry header : requestContext.getHeaders().entrySet()) {
            builder.append("    ").append((String)header.getKey()).append(": ");
            for (Object headerValue : (List)header.getValue()) {
                builder.append(this.maskValue((String)header.getKey(), headerValue.toString()));
            }
            builder.append("\n");
        }
        if (MediaType.APPLICATION_JSON_TYPE.equals((Object)requestContext.getMediaType())) {
            requestContext.setEntityStream((OutputStream)new LoggingStream(requestContext.getEntityStream()));
        }
        builder.append("------------- End Request -------------\n");
        LOGGER.info(builder.toString());
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (!LOGGER.isInfoEnabled()) {
            return;
        }
        StringBuilder builder = new StringBuilder("\n---------- Response ----------\n");
        builder.append("  Status: ").append(responseContext.getStatus()).append("\n");
        builder.append("  Headers:\n");
        for (Map.Entry header : responseContext.getHeaders().entrySet()) {
            builder.append("    ").append((String)header.getKey()).append(": ");
            for (Object headerValue : (List)header.getValue()) {
                builder.append(headerValue.toString()).append(",");
            }
            builder.append("\n");
        }
        builder.append("------------- End Response -------------\n");
        LOGGER.info(builder.toString());
        if (requestContext.getUri().toString().contains("/_matrix/media/r0")) {
            return;
        }
        if (MediaType.APPLICATION_JSON_TYPE.equals((Object)responseContext.getMediaType())) {
            byte[] content = StreamHelper.toByteArray(responseContext.getEntityStream());
            LOGGER.info("Body:\n" + new String(content, StandardCharsets.UTF_8));
            responseContext.setEntityStream((InputStream)new ByteArrayInputStream(content));
        }
    }

    private String maskValue(String name, String value) {
        if ("Authorization".equalsIgnoreCase(name) && value.toLowerCase().startsWith(BEARER_PREFIX)) {
            return value.substring(0, BEARER_PREFIX_LENGTH) + "***";
        }
        return value;
    }

    static class LoggingStream
    extends FilterOutputStream {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        LoggingStream(OutputStream inner) {
            super(inner);
        }

        @Override
        public void write(int i) throws IOException {
            this.baos.write(i);
            this.out.write(i);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            LOGGER.info("Body:\n" + this.baos.toString(StandardCharsets.UTF_8.name()));
        }
    }
}

