/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client;

import io.github.ma1uta.matrix.client.model.serverdiscovery.HomeserverInfo;
import io.github.ma1uta.matrix.client.model.serverdiscovery.IdentityServerInfo;
import io.github.ma1uta.matrix.client.model.serverdiscovery.ServerDiscoveryResponse;

public class ConnectionInfo {
    private String domain;
    private String userId;
    private String accessToken;
    private String deviceId;
    private ServerDiscoveryResponse serverInfo;

    public ConnectionInfo() {
    }

    public ConnectionInfo(String domain) {
        this.domain = domain;
    }

    public ConnectionInfo(ConnectionInfo connectionInfo) {
        this.domain = connectionInfo.getDomain();
        this.userId = connectionInfo.getUserId();
        this.accessToken = connectionInfo.getAccessToken();
        this.deviceId = connectionInfo.getDeviceId();
        if (connectionInfo.getServerInfo() != null) {
            this.serverInfo = new ServerDiscoveryResponse();
            if (connectionInfo.getServerInfo().getHomeserver() != null) {
                this.serverInfo.setHomeserver(new HomeserverInfo());
                this.serverInfo.getHomeserver().setBaseUrl(connectionInfo.getServerInfo().getHomeserver().getBaseUrl());
            }
            if (connectionInfo.getServerInfo().getIdentityServer() != null) {
                this.serverInfo.setIdentityServer(new IdentityServerInfo());
                this.serverInfo.getIdentityServer().setBaseUrl(connectionInfo.getServerInfo().getIdentityServer().getBaseUrl());
            }
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public ServerDiscoveryResponse getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(ServerDiscoveryResponse serverInfo) {
        this.serverInfo = serverInfo;
    }
}

