/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client;

import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeserverVerifier
implements HostnameVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(HomeserverVerifier.class);
    private static final String ALT_DNS_NAME_TYPE = "2";
    private static final String ALT_IP_ADDRESS_TYPE = "7";
    private final String domain;

    public HomeserverVerifier(String domain) {
        this.domain = domain;
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        try {
            Certificate peerCertificate = session.getPeerCertificates()[0];
            if (peerCertificate instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)peerCertificate;
                LOGGER.trace("Check certificate: {}", (Object)x509Certificate);
                if (x509Certificate.getSubjectAlternativeNames() == null) {
                    LOGGER.trace("Empty subject alternative names");
                    return false;
                }
                if (this.hasMatchedSubjectNames(x509Certificate)) {
                    return true;
                }
            } else {
                LOGGER.trace("Unknown certificate type \"{}\", ignore", (Object)peerCertificate.getType());
            }
        }
        catch (CertificateParsingException | SSLPeerUnverifiedException e) {
            LOGGER.error("Unable to check remote host", (Throwable)e);
            return false;
        }
        return false;
    }

    private boolean hasMatchedSubjectNames(X509Certificate x509Certificate) {
        try {
            block9: for (List<?> subjectAlternativeNames : x509Certificate.getSubjectAlternativeNames()) {
                String subjectType;
                if (subjectAlternativeNames == null || subjectAlternativeNames.size() < 2 || subjectAlternativeNames.get(0) == null || subjectAlternativeNames.get(1) == null) continue;
                switch (subjectType = subjectAlternativeNames.get(0).toString()) {
                    case "2": 
                    case "7": {
                        String altSubjectName = subjectAlternativeNames.get(1).toString();
                        LOGGER.trace("Found subject name: {}", (Object)altSubjectName);
                        if (!this.match(altSubjectName)) continue block9;
                        LOGGER.trace("Matched");
                        return true;
                    }
                }
                LOGGER.trace("Unusable subject type: " + subjectType);
            }
        }
        catch (CertificateParsingException e) {
            LOGGER.error("Unable to parse the certificate", (Throwable)e);
            return false;
        }
        LOGGER.trace("Haven't found matched subject names");
        return false;
    }

    private boolean match(String altSubjectName) {
        if (altSubjectName.startsWith("*.")) {
            String subjectNameWithoutMask = altSubjectName.substring(1);
            LOGGER.trace("Check the origin domain \"{}\" with the wildcard \"{}\"", (Object)this.domain, (Object)altSubjectName);
            return this.domain.toLowerCase().endsWith(subjectNameWithoutMask.toLowerCase());
        }
        LOGGER.trace("Compare the origin domain \"{}\" with the subject name: \"{}\"", (Object)this.domain, (Object)altSubjectName);
        return this.domain.equalsIgnoreCase(altSubjectName);
    }
}

