/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.tag.Tags;
import io.github.ma1uta.matrix.event.nested.TagInfo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0/user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface TagApi {
    @Operation(summary="List the tags set by a user on a room.", responses={@ApiResponse(responseCode="200", description="The list of tags for the user for the room.", content={@Content(schema=@Schema(implementation=Tags.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"User data"})
    @GET
    @Secured
    @Path(value="/{userId}/rooms/{roomId}/tags")
    public void showTags(@Parameter(description="The id of the user to get tags for. The access token must be authorized to make requests for this user id.", required=true) @PathParam(value="userId") Id var1, @Parameter(description="The id of the room to get tags for.", required=true) @PathParam(value="roomId") Id var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Add a tag to the room.", responses={@ApiResponse(responseCode="200", description="The tag was successfully added.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"User data"})
    @PUT
    @Secured
    @Path(value="/{userId}/rooms/{roomId}/tags/{tag}")
    public void addTag(@Parameter(description="The id of the user to add a tag for. The access token must be authorized to make requests for this user id.", required=true) @PathParam(value="userId") Id var1, @Parameter(description="The id of the room to add a tag to.", required=true) @PathParam(value="roomId") Id var2, @Parameter(description="The tag to add.", required=true) @PathParam(value="tag") String var3, @RequestBody(description="TagInfo data.") TagInfo var4, @Context UriInfo var5, @Context HttpHeaders var6, @Suspended AsyncResponse var7, @Context SecurityContext var8);

    @Operation(summary="Remove a tag from the room.", responses={@ApiResponse(responseCode="200", description="The tag was successfully removed.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"User data"})
    @DELETE
    @Secured
    @Path(value="/{userId}/rooms/{roomId}/tags/{tag}")
    public void deleteTag(@Parameter(description="The id of the user to remove a tag for. The access token must be authorized to make requests for this user id.", required=true) @PathParam(value="userId") Id var1, @Parameter(description="The id of the room to remove a tag from.", required=true) @PathParam(value="roomId") Id var2, @Parameter(description="The tag to remove.", required=true) @PathParam(value="tag") String var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    public static class Tag {
        public static final String FAVOURITE = "m.favourite";
        public static final String LOWPRIOORITY = "m.lowpriority";

        protected Tag() {
        }
    }
}

