/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.ErrorResponse;
import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.RateLimitedErrorResponse;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.room.CreateRoomRequest;
import io.github.ma1uta.matrix.client.model.room.InviteRequest;
import io.github.ma1uta.matrix.client.model.room.JoinRequest;
import io.github.ma1uta.matrix.client.model.room.JoinedRoomsResponse;
import io.github.ma1uta.matrix.client.model.room.KickRequest;
import io.github.ma1uta.matrix.client.model.room.NewVersion;
import io.github.ma1uta.matrix.client.model.room.PublicRoomsRequest;
import io.github.ma1uta.matrix.client.model.room.PublicRoomsResponse;
import io.github.ma1uta.matrix.client.model.room.ReplacementRoom;
import io.github.ma1uta.matrix.client.model.room.RoomId;
import io.github.ma1uta.matrix.client.model.room.RoomResolveResponse;
import io.github.ma1uta.matrix.client.model.room.RoomVisibility;
import io.github.ma1uta.matrix.client.model.room.UnbanRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface RoomApi {
    @Operation(summary="Create a new room with various configuration options.", description="The server MUST apply the normal state resolution rules when creating the new room, including checking power levels for each event.", responses={@ApiResponse(responseCode="200", description="Information about the newly created room.", content={@Content(schema=@Schema(implementation=RoomId.class))}), @ApiResponse(responseCode="400", description="The request is invalid. A meaningful errcode and description error text will be returned.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room creation"})
    @POST
    @Secured
    @Path(value="/createRoom")
    public void create(@RequestBody(description="JSON body request.") CreateRoomRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Create a new mapping from room alias to room ID.", responses={@ApiResponse(responseCode="200", description="The mapping was created.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="409", description="A room alias with that name already exists.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room directory"})
    @PUT
    @Secured
    @Path(value="/directory/room/{roomAlias}")
    public void createAlias(@Parameter(description="The room alias to set", required=true) @PathParam(value="roomAlias") Id var1, @RequestBody(description="JSON body request") RoomId var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Requests that the server resolve a room alias to a room ID. The server will use the federation API to resolve the alias if the domain part of the alias does not correspond to the server's own domain.", responses={@ApiResponse(responseCode="200", description="The room ID and other information for this alias.", content={@Content(schema=@Schema(implementation=RoomResolveResponse.class))}), @ApiResponse(responseCode="404", description="There is no mapped room ID for this room alias.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, tags={"Room directory"})
    @GET
    @Path(value="/directory/room/{roomAlias}")
    public void resolveAlias(@Parameter(description="The room alias", required=true) @PathParam(value="roomAlias") Id var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Remove a mapping of room alias to room ID.", responses={@ApiResponse(responseCode="200", description="The mapping was deleted.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room directory"})
    @DELETE
    @Secured
    @Path(value="/directory/room/{roomAlias}")
    public void deleteAlias(@Parameter(description="The room alias to remove.", required=true) @PathParam(value="roomAlias") Id var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="This API returns a list of the user's current rooms.", responses={@ApiResponse(responseCode="200", description="A list of the rooms the user is in.", content={@Content(schema=@Schema(implementation=JoinedRoomsResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room membership"})
    @GET
    @Secured
    @Path(value="/joined_rooms")
    public void joinedRooms(@Context UriInfo var1, @Context HttpHeaders var2, @Suspended AsyncResponse var3, @Context SecurityContext var4);

    @Operation(summary="This API invites a user to participate in a particular room. They do not start participating in the room until they actually join the room.", responses={@ApiResponse(responseCode="200", description="The user has been invited to join the room.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="403", description="You do not have permission to invite the user to the room. A meaningful errcode and description error text will be returned. ", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room membership"})
    @POST
    @RateLimit
    @Secured
    @Path(value="/rooms/{roomId}/invite")
    public void invite(@Parameter(description="The room identifier (not alias) to which to invite the user.", required=true) @PathParam(value="roomId") Id var1, @RequestBody(description="JSON body request") InviteRequest var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="This API starts a user participating in a particular room, if that user is allowed to participate in that room. After this call, the client is allowed to see all current state events in the room, and all subsequent events associated with the room until the user leaves the room.", responses={@ApiResponse(responseCode="200", description="The room has been joined. The joined room ID must be returned in the room_id field.", content={@Content(schema=@Schema(implementation=RoomId.class))}), @ApiResponse(responseCode="403", description="You do not have permission to join the room. A meaningful errcode and description error text will be returned.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room membership"})
    @POST
    @RateLimit
    @Secured
    @Path(value="/rooms/{roomId}/join")
    public void joinById(@Parameter(description="The room identifier (not alias) to join.", required=true) @PathParam(value="roomId") Id var1, @RequestBody(description="JSON body request") JoinRequest var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="This API starts a user participating in a particular room, if that user is allowed to participate in that room. After this call, the client is allowed to see all current state events in the room, and all subsequent events associated with the room until the user leaves the room.", responses={@ApiResponse(responseCode="200", description="The room has been joined. The joined room ID must be returned in the room_id field.", content={@Content(schema=@Schema(implementation=RoomId.class))}), @ApiResponse(responseCode="403", description="You do not have permission to join the room. A meaningful errcode and description error text will be returned.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room membership"})
    @POST
    @RateLimit
    @Secured
    @Path(value="/join/{roomIdOrAlias}")
    public void joinByIdOrAlias(@Parameter(description="The room identifier or alias to join.", required=true) @PathParam(value="roomIdOrAlias") Id var1, @Parameter(name="server_name", description="The servers to attempt to join the room through. One of the servers must be participating in the room.") @QueryParam(value="server_name") List<String> var2, @RequestBody(description="JSON body request.") JoinRequest var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    @Operation(summary="This API stops a user participating in a particular room.", description="If the user was already in the room, they will no longer be able to see new events in the room. If the room requires an invite to join, they will need to be re-invited before they can re-join. If the user was invited to the room, but had not joined, this call serves to reject the invite.The user will still be allowed to retrieve history from the room which they were previously allowed to see.", responses={@ApiResponse(responseCode="200", description="The room has been left.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room membership"})
    @POST
    @RateLimit
    @Secured
    @Path(value="/rooms/{roomId}/leave")
    public void leave(@Parameter(description="The room identifier to leave.", required=true) @PathParam(value="roomId") Id var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="This API stops a user remembering about a particular room. In general, history is a first class citizen in Matrix. After this API is called, however, a user will no longer be able to retrieve history for this room. If all users on a homeserver forget a room, the room is eligible for deletion from that homeserver.", responses={@ApiResponse(responseCode="200", description="The room has been forgotten.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="400", description="The user has not left the room.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room membership"})
    @POST
    @RateLimit
    @Secured
    @Path(value="/rooms/{roomId}/forget")
    public void forget(@Parameter(description="The room identifier to forget.", required=true) @PathParam(value="roomId") Id var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Kick a user from the room.", responses={@ApiResponse(responseCode="200", description="The user has been kicked from the room.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="403", description="You do not have permission to kick the user from the room. A meaningful errcode and description error text will be returned.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room membership"})
    @POST
    @Secured
    @Path(value="/rooms/{roomId}/kick")
    public void kick(@Parameter(description="The room identifier (not alias) from which the user should be kicked.", required=true) @PathParam(value="roomId") Id var1, @RequestBody(description="JSON body request") KickRequest var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Ban a user in the room. If the user is currently in the room, also kick them.", responses={@ApiResponse(responseCode="200", description="The user has been kicked and banned from the room.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="403", description="You do not have permission to ban the user from the room. A meaningful errcode and description error text will be returned.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room membership"})
    @POST
    @Secured
    @Path(value="/rooms/{roomId}/ban")
    public void ban(@Parameter(description="The room identifier (not alias) from which the user should be banned.", required=true) @PathParam(value="roomId") Id var1, @RequestBody(description="JSON body request.") KickRequest var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Unban a user from the room. This allows them to be invited to the room, and join if they would otherwise be allowed to join according to its join rules.", responses={@ApiResponse(responseCode="200", description="The user has been unbanned from the room.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="403", description="You do not have permission to unban the user from the room. A meaningful errcode and description error text will be returned.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room membership"})
    @POST
    @Secured
    @Path(value="/rooms/{roomId}/unban")
    public void unban(@Parameter(description="The room identifier (not alias) from which the user should be unbanned.", required=true) @PathParam(value="roomId") Id var1, @RequestBody(description="JSON body request.") UnbanRequest var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Gets the visibility of a given room on the server's public room directory.", responses={@ApiResponse(responseCode="200", description="The visibility of the room in the directory", content={@Content(schema=@Schema(implementation=RoomVisibility.class))}), @ApiResponse(responseCode="404", description="The room is not known to the server", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, tags={"Room discovery"})
    @GET
    @Path(value="/directory/list/room/{roomId}")
    public void getVisibility(@Parameter(description="The room ID.", required=true) @PathParam(value="roomId") Id var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Sets the visibility of a given room in the server's public room directory.", responses={@ApiResponse(responseCode="200", description="The visibility was updated, or no change was needed.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="404", description="The room is not known to the server.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room discovery"})
    @PUT
    @Secured
    @Path(value="/directory/list/room/{roomId}")
    public void setVisibility(@Parameter(description="The room ID.", required=true) @PathParam(value="roomId") Id var1, @RequestBody(description="JSON body request.") RoomVisibility var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Lists the public rooms on the server. This API returns paginated responses. The rooms are ordered by the number of joined members, with the largest rooms first.", responses={@ApiResponse(responseCode="200", description="A list of the rooms on the server.", content={@Content(schema=@Schema(implementation=PublicRoomsResponse.class))})}, tags={"Room discovery"})
    @GET
    @Path(value="/publicRooms")
    public void showPublicRooms(@Parameter(description="Limit the number of results returned.") @QueryParam(value="limit") Long var1, @Parameter(description="A pagination token from a previous request, allowing clients to get the next (or previous) batch of rooms. The direction of pagination is specified solely by which token is supplied, rather than via an explicit flag.") @QueryParam(value="since") String var2, @Parameter(description="The server to fetch the public room lists from. Defaults to the local server.") @QueryParam(value="server") String var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6);

    @Operation(summary="Lists the public rooms on the server, with optional filter. This API returns paginated responses. The rooms are ordered by the number of joined members, with the largest rooms first.", responses={@ApiResponse(responseCode="200", description="A list of the rooms on the server.", content={@Content(schema=@Schema(implementation=PublicRoomsResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room discovery"})
    @POST
    @Secured
    @Path(value="/publicRooms")
    public void searchPublicRooms(@Parameter(description="The server to fetch the public room lists from. Defaults to the local server.") @QueryParam(value="server") String var1, @RequestBody(description="JSON body request.") PublicRoomsRequest var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Upgrades the given room to a particular room version, migrating as much data as possible over to the new room. See the room_upgrades module for more information on what this entails.", responses={@ApiResponse(responseCode="200", description="The room was successfully upgraded.", content={@Content(schema=@Schema(implementation=ReplacementRoom.class))}), @ApiResponse(responseCode="400", description="The request was invalid. One way this can happen is if the room version requested is not supported by the homeserver.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="The user is not permitted to upgrade the room.\n", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room directory"})
    @POST
    @Secured
    @Path(value="/rooms/{roomId}/upgrade")
    public void upgrade(@Parameter(description="The ID of the room to upgrade.", required=true) @PathParam(value="roomId") Id var1, @RequestBody(description="The new version for the room.", required=true) NewVersion var2, @Context UriInfo var3, @Context HttpHeaders var4, @Context AsyncResponse var5, @Context SecurityContext var6);

    public static class Preset {
        public static final String PRIVATE_CHAT = "private_chat";
        public static final String PUBLIC_CHAT = "public_chat";
        public static final String TRUSTED_PRIVATE_CHAT = "trusted_private_chat";

        protected Preset() {
        }
    }

    public static class Visibility {
        public static final String PUBLIC = "public";
        public static final String PRIVATE = "private";

        protected Visibility() {
        }
    }
}

