/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.RateLimitedErrorResponse;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.receipt.ReadMarkersRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0/rooms")
@Produces(value={"application/json"})
public interface ReceiptApi {
    @Operation(summary="This API updates the marker for the given receipt type to the event ID specified.", responses={@ApiResponse(responseCode="200", description="The receipt was sent.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room participation"})
    @POST
    @RateLimit
    @Secured
    @Path(value="/{roomId}/receipt/{receiptType}/{eventId}")
    public void receipt(@Parameter(description="The room in which to send the event.", required=true) @PathParam(value="roomId") Id var1, @Parameter(description="The type of receipt to send.", required=true, schema=@Schema(allowableValues={"m.read"})) @PathParam(value="receiptType") String var2, @Parameter(description="The event ID to acknowledge up to.", required=true) @PathParam(value="eventId") Id var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    @Operation(summary="Sets the position of the read marker for a given room, and optionally the read receipt's location.", responses={@ApiResponse(responseCode="200", description="The read marker, and read receipt if provided, have been updated.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Read Markers"})
    @POST
    @Secured
    @RateLimit
    @Path(value="/{roomId}/read_markers")
    public void readMarkers(@Parameter(description="The room ID to set the read marker in for the user.", required=true) @PathParam(value="roomId") Id var1, @RequestBody(description="JSON body request.") ReadMarkersRequest var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    public static class Receipt {
        public static final String READ = "m.read";

        protected Receipt() {
        }
    }
}

