/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.ErrorResponse;
import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.RateLimitedErrorResponse;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.profile.AvatarUrl;
import io.github.ma1uta.matrix.client.model.profile.DisplayName;
import io.github.ma1uta.matrix.client.model.profile.Profile;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0/profile")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface ProfileApi {
    @Operation(summary="his API sets the given user's display name. You must have permission to set this user's display name, e.g. you need to have their access_token.", responses={@ApiResponse(responseCode="200", description="The display name was set.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"User data"})
    @PUT
    @RateLimit
    @Secured
    @Path(value="/{userId}/displayname")
    public void setDisplayName(@Parameter(description="The user whose display name to set.", required=true) @PathParam(value="userId") Id var1, @RequestBody(description="JSON body request.") DisplayName var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Get the user's display name. This API may be used to fetch the user's own displayname or to query the name of other users; either locally or on remote homeservers.", responses={@ApiResponse(responseCode="200", description="The display name for this user.", content={@Content(schema=@Schema(implementation=DisplayName.class))}), @ApiResponse(responseCode="404", description="There is no display name for this user or this user does not exist.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, tags={"User data"})
    @GET
    @Path(value="/{userId}/displayname")
    public void showDisplayName(@Parameter(description="The user whose display name to get.", required=true) @PathParam(value="userId") Id var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="This API sets the given user's avatar URL. You must have permission to set this user's avatar URL, e.g. you need to have their access_token.", responses={@ApiResponse(responseCode="200", description="The avatar URL was set.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"User data"})
    @PUT
    @RateLimit
    @Secured
    @Path(value="/{userId}/avatar_url")
    public void setAvatarUrl(@Parameter(description="The user whose avatar URL to set.", required=true) @PathParam(value="userId") Id var1, @RequestBody(description="JSON body request") AvatarUrl var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Get the user's avatar URL. This API may be used to fetch the user's own avatar URL or to query the URL of other users;  either locally or on remote homeservers.", responses={@ApiResponse(responseCode="200", description="The avatar URL for this user.", content={@Content(schema=@Schema(implementation=AvatarUrl.class))}), @ApiResponse(responseCode="404", description="There is no avatar URL for this user or this user does not exist.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, tags={"User data"})
    @GET
    @Path(value="/{userId}/avatar_url")
    public void showAvatarUrl(@Parameter(description="The user whose avatar URL to get.", required=true) @PathParam(value="userId") Id var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Get the combined profile information for this user. This API may be used to fetch the user's own profile information or other users; either locally or on remote homeservers. This API may return keys which are not limited to displayname or avatar_url.", responses={@ApiResponse(responseCode="200", description="The avatar URL for this user.", content={@Content(schema=@Schema(implementation=Profile.class))}), @ApiResponse(responseCode="404", description="There is no profile information for this user or this user does not exist.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, tags={"User data"})
    @GET
    @Path(value="/{userId}")
    public void profile(@Parameter(description="The user whose profile information to get.", required=true) @PathParam(value="userId") Id var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);
}

