/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.RateLimitedErrorResponse;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.userdirectory.SearchRequest;
import io.github.ma1uta.matrix.client.model.userdirectory.SearchResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0/user_directory")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface UserDirectoryApi {
    @Operation(summary="Performs a search for users on the homeserver.", description="The homeserver may determine which subset of users are searched, however the homeserver MUST at a minimum consider the users the requesting user shares a room with and those who reside in public rooms (known to the homeserver). The search MUST consider local users to the homeserver, and SHOULD query remote users as part of the search. The search is performed case-insensitively on user IDs and display names preferably using a collation determined based upon * the Accept-Language header provided in the request, if present.", responses={@ApiResponse(responseCode="200", description="The results of the search.", content={@Content(schema=@Schema(implementation=SearchResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @POST
    @RateLimit
    @Secured
    @Path(value="/search")
    public void searchUsers(@RequestBody(description="JSON body request.") SearchRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);
}

