/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.protocol.Protocol;
import io.github.ma1uta.matrix.protocol.ProtocolLocation;
import io.github.ma1uta.matrix.protocol.ProtocolUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Api(value="ThirdPartyProtocol", description="Application services can provide access to third party networks via bridging.This allows Matrix users to communicate with users on other communication platforms, with messages ferried back and forthby the application service. A single application service may bridge multiple third party networks, and many individuallocations within those networks. A single third party network location may be bridged to multiple Matrix rooms.")
@Path(value="/_matrix/client/r0/thirdparty")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface ThirdPartyProtocolApi {
    @ApiOperation(value="Fetches the overall metadata about protocols supported by the homeserver.Includes both the available protocols and all fields required for queries against each protocol.", response=Map.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The protocols supported by the homeserver.")})
    @GET
    @Secured
    @Path(value="/protocols")
    public void protocols(@Context HttpServletRequest var1, @Suspended AsyncResponse var2);

    @ApiOperation(value="Fetches the metadata from the homeserver about a particular third party protocol.", response=Protocol.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The protocol was found and metadata returned."), @ApiResponse(code=404, message="The protocol is unknown.")})
    @GET
    @Secured
    @Path(value="/protocol/{protocol}")
    public void protocol(@ApiParam(value="the name of the protocol", required=true) @PathParam(value="protocol") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);

    @ApiOperation(value="Requesting this endpoint with a valid protocol name results in a list of successful mapping resultsin a JSON array.", notes="Each result contains objects to represent the Matrix room or rooms that represent a portal to this third party network. Each has the Matrix room alias string, an identifier for the particular third party network protocol, and an object containing the network-specific fields that comprise this identifier.It should attempt to canonicalise the identifier as much as reasonably possible given the network type.", response=ProtocolLocation.class, responseContainer="List", authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="At least one portal room was found."), @ApiResponse(code=404, message="No portal rooms were found.")})
    @GET
    @Secured
    @Path(value="/location/{protocol}")
    public void locationProtocol(@ApiParam(value="The protocol used to communicate to the third party network.", required=true) @PathParam(value="protocol") String var1, @Context UriInfo var2, @Context HttpServletRequest var3, @Suspended AsyncResponse var4);

    @ApiOperation(value="Retrieve a Matrix User ID linked to a user on the third party service, given a set of user parameters.", response=ProtocolUser.class, responseContainer="List", authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The Matrix User IDs found with the given parameters."), @ApiResponse(code=404, message="The Matrix User ID was not found.")})
    @GET
    @Secured
    @Path(value="/user/{protocol}")
    public void userProtocol(@ApiParam(value="The name of the protocol", required=true) @PathParam(value="protocol") String var1, @Context UriInfo var2, @Context HttpServletRequest var3, @Suspended AsyncResponse var4);

    @ApiOperation(value="Retrieve an array of third party network locations from a Matrix room alias.", response=ProtocolLocation.class, responseContainer="List", authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="At least one portal room was found."), @ApiResponse(code=404, message="No portal rooms were found.")})
    @GET
    @Secured
    @Path(value="/location")
    public void location(@ApiParam(value="The Matrix room alias to look up", required=true) @QueryParam(value="alias") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);

    @ApiOperation(value="Retrieve an array of third party users from a Matrix User ID.", response=ProtocolUser.class, responseContainer="List", authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The Matrix User IDs found with the given parameters."), @ApiResponse(code=404, message="The Matrix User ID was not found.")})
    @GET
    @Secured
    @Path(value="/user")
    public void user(@ApiParam(value="The Matrix User Id to look up", required=true) @QueryParam(value="userid") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);
}

