/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.Event;
import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.presence.PresenceList;
import io.github.ma1uta.matrix.client.model.presence.PresenceRequest;
import io.github.ma1uta.matrix.client.model.presence.PresenceStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="Presence", description="Each user has the concept of presence information.")
@Path(value="/_matrix/client/r0/presence")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface PresenceApi {
    @ApiOperation(value="This API sets the given user's presence state. When setting the status, the activity time is updated to reflect that activity; the client does not need to specify the last_active_ago field. You cannot set the presence state of another user.", response=EmptyResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The new presence state was set."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @PUT
    @RateLimit
    @Secured
    @Path(value="/{userId}/status")
    public void setPresenceStatus(@ApiParam(value="The user whose presence state to update.", required=true) @PathParam(value="userId") String var1, @ApiParam(value="JSON body request.") PresenceRequest var2, @Context HttpServletRequest var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="Get the given user's presence state.", response=PresenceStatus.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The presence state for this user."), @ApiResponse(code=403, message="You are not allowed to see this user's presence status."), @ApiResponse(code=404, message="There is no presence state for this user. This user may not exist or isn't exposing presence information to you.")})
    @GET
    @Secured
    @Path(value="/{userId}/status")
    public void getPresenceStatus(@ApiParam(value="The user whose presence state to get.", required=true) @PathParam(value="userId") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);

    @ApiOperation(value="Adds or removes users from this presence list.", response=EmptyResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The list was updated."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @POST
    @RateLimit
    @Secured
    @Path(value="/list/{userId}")
    public void setPresenceList(@ApiParam(value="The user whose presence list is being modified.", required=true) @PathParam(value="userId") String var1, @ApiParam(value="JSON body request") PresenceList var2, @Context HttpServletRequest var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="Retrieve a list of presence events for every user on this list.", response=Event.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="A list of presence events for this list.")})
    @GET
    @Path(value="/list/{userId}")
    public void getPresenceList(@ApiParam(value="The user whose presence list should be retrieved.", required=true) @PathParam(value="userId") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);
}

