/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.content.ContentConfig;
import io.github.ma1uta.matrix.client.model.content.ContentUri;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="Content", description="This module allows users to upload content to their homeserver which is retrievable from other homeservers. Its' purpose is to allow users to share attachments in a room. Key locations are represented as Matrix Key (MXC) URIs.")
@Path(value="/_matrix/media/r0")
public interface ContentApi {
    @ApiOperation(value="Upload some content to the content repository.", response=ContentUri.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The MXC URI for the uploaded content."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @POST
    @RateLimit
    @Secured
    @Path(value="/upload")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public void upload(@ApiParam(value="The file content") InputStream var1, @ApiParam(value="The name of the file being uploaded.") @QueryParam(value="filename") String var2, @ApiParam(value="The content type of the file being uploaded") @HeaderParam(value="Content-Type") String var3, @Context HttpServletRequest var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @ApiOperation(value="Download content from the content repository.", response=OutputStream.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The content that was previously uploaded."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @GET
    @RateLimit
    @Path(value="/download/{serverName}/{mediaId}")
    public void download(@ApiParam(value="The server name from the mxc:// URI (the authoritory component).", required=true) @PathParam(value="serverName") String var1, @ApiParam(value="The media ID from the mxc:// URI (the path component).", required=true) @PathParam(value="mediaId") String var2, @ApiParam(value="Indicates to the server that it should not attempt to fetch the media if it is deemed remote. This is to prevent routing loops where the server contacts itself. Defaults to true if not provided.") @QueryParam(value="allow_remote") Boolean var3, @Context HttpServletRequest var4, @Suspended AsyncResponse var5);

    @ApiOperation(value="Download content from the content repository as a given filename.", response=OutputStream.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The content that was previously uploaded."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @GET
    @RateLimit
    @Path(value="/download/{serverName}/{mediaId}/{fileName}")
    public void downloadFile(@ApiParam(value="The server name from the mxc:// URI (the authoritory component).", required=true) @PathParam(value="serverName") String var1, @ApiParam(value="The media ID from the mxc:// URI (the path component).", required=true) @PathParam(value="mediaId") String var2, @ApiParam(value="The filename to give in the Content-Disposition.", required=true) @PathParam(value="fileName") String var3, @ApiParam(value="Indicates to the server that it should not attempt to fetch the media if it is deemed remote. This is to prevent routing loops where the server contacts itself. Defaults to true if not provided.") @QueryParam(value="allow_remote") Boolean var4, @Context HttpServletRequest var5, @Suspended AsyncResponse var6);

    @ApiOperation(value="Download a thumbnail of the content from the content repository.", response=OutputStream.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The content that was previously uploaded."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @GET
    @RateLimit
    @Path(value="/thumbnail/{serverName}/{mediaId}")
    public void thumbnail(@ApiParam(value="The server name from the mxc:// URI (the authoritory component).", required=true) @PathParam(value="serverName") String var1, @ApiParam(value="The media ID from the mxc:// URI (the path component)", required=true) @PathParam(value="mediaId") String var2, @ApiParam(value="he desired width of the thumbnail. The actual thumbnail may not match the size specified.") @QueryParam(value="width") Long var3, @ApiParam(value="The desired height of the thumbnail. The actual thumbnail may not match the size specified.") @QueryParam(value="height") Long var4, @ApiParam(value="The desired resizing method.", allowableValues="['crop','scale']") @QueryParam(value="method") String var5, @ApiParam(value="Indicates to the server that it should not attempt to fetch the media if it is deemed remote. This is to prevent routing loops where the server contacts itself. Defaults to true if not provided.") @QueryParam(value="allow_remote") Boolean var6, @Context HttpServletRequest var7, @Suspended AsyncResponse var8);

    @ApiOperation(value="Get information about a PATH for a client.", response=Map.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The content that was previously uploaded."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @GET
    @RateLimit
    @Secured
    @Path(value="/preview_url")
    @Produces(value={"application/json"})
    public void previewUrl(@ApiParam(value="The PATH to get a preview of.", required=true) @QueryParam(value="url") String var1, @ApiParam(value="The preferred point in time to return a preview for. The server may return a newer version if it does not have the requested version available.") @QueryParam(value="ts") String var2, @Context HttpServletRequest var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="his endpoint allows clients to retrieve the configuration of the content repository, suchas upload limitations.", notes="Clients SHOULD use this as a guide when using content repository endpoints. All values are intentionally left optional. Clients SHOULD follow the advice given in the field description when the field is not available. NOTE: Both clients and server administrators should be aware that proxies between the client and the server may affect the apparent behaviour of content repository APIs, for example, proxies may enforce a lower upload size limit than is advertised by the server on this endpoint.", response=ContentConfig.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The public content repository configuration for the matrix server."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @GET
    @RateLimit
    @Secured
    @Path(value="/config")
    @Produces(value={"application/json"})
    public void config(@Context HttpServletRequest var1, @Suspended AsyncResponse var2, @Context SecurityContext var3);

    public static class Method {
        public static final String CROP = "crop";
        public static final String SCALE = "scale";

        protected Method() {
        }
    }
}

