/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.room.CreateRoomRequest;
import io.github.ma1uta.matrix.client.model.room.InviteRequest;
import io.github.ma1uta.matrix.client.model.room.JoinRequest;
import io.github.ma1uta.matrix.client.model.room.JoinedRoomsResponse;
import io.github.ma1uta.matrix.client.model.room.KickRequest;
import io.github.ma1uta.matrix.client.model.room.PublicRoomsRequest;
import io.github.ma1uta.matrix.client.model.room.PublicRoomsResponse;
import io.github.ma1uta.matrix.client.model.room.RoomId;
import io.github.ma1uta.matrix.client.model.room.RoomVisibility;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="Room", description="Rooms api.")
@Path(value="/_matrix/client/r0")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface RoomApi {
    @ApiOperation(value="Create a new room with various configuration options.", notes="The server MUST apply the normal state resolution rules when creating the new room, including checking power levels for each event.", response=RoomId.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Information about the newly created room."), @ApiResponse(code=400, message="The request is invalid. A meaningful errcode and description error text will be returned.")})
    @POST
    @Secured
    @Path(value="/createRoom")
    public RoomId create(@ApiParam(value="JSON body request.") CreateRoomRequest var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3, @Context SecurityContext var4);

    @ApiOperation(value="Create a new mapping from room alias to room ID.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The mapping was created."), @ApiResponse(code=409, message="A room alias with that name already exists.")})
    @PUT
    @Secured
    @Path(value="/directory/room/{roomAlias}")
    public EmptyResponse newAlias(@ApiParam(value="The room alias to set", required=true) @PathParam(value="roomAlias") String var1, @ApiParam(value="JSON body request") RoomId var2, @Context HttpServletRequest var3, @Context HttpServletResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="Requests that the server resolve a room alias to a room ID. The server will use the federation API to resolve the alias if the domain part of the alias does not correspond to the server's own domain.", response=RoomId.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The room ID and other information for this alias."), @ApiResponse(code=404, message="There is no mapped room ID for this room alias.")})
    @GET
    @Path(value="/directory/room/{roomAlias}")
    public RoomId resolve(@ApiParam(value="The room alias", required=true) @PathParam(value="roomAlias") String var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3);

    @ApiOperation(value="Remove a mapping of room alias to room ID.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The mapping was deleted.")})
    @DELETE
    @Secured
    @Path(value="/directory/room/{roomAlias}")
    public EmptyResponse delete(@ApiParam(value="The room alias to remove.", required=true) @PathParam(value="roomAlias") String var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3, @Context SecurityContext var4);

    @ApiOperation(value="This API returns a list of the user's current rooms.", response=JoinedRoomsResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="A list of the rooms the user is in.")})
    @GET
    @Secured
    @Path(value="/joined_rooms")
    public JoinedRoomsResponse joinedRooms(@Context HttpServletRequest var1, @Context HttpServletResponse var2, @Context SecurityContext var3);

    @ApiOperation(value="This API invites a user to participate in a particular room. They do not start participating in the room until they actually join the room.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The user has been invited to join the room."), @ApiResponse(code=403, message="You do not have permission to invite the user to the room. A meaningful errcode and description error text will be returned. "), @ApiResponse(code=429, message="This request was rate-limited.")})
    @POST
    @RateLimit
    @Secured
    @Path(value="/rooms/{roomId}/invite")
    public EmptyResponse invite(@ApiParam(value="The room identifier (not alias) to which to invite the user.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="JSON body request") InviteRequest var2, @Context HttpServletRequest var3, @Context HttpServletResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="This API starts a user participating in a particular room, if that user is allowed to participate in that room. After this call, the client is allowed to see all current state events in the room, and all subsequent events associated with the room until the user leaves the room.", response=RoomId.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The room has been joined. The joined room ID must be returned in the room_id field."), @ApiResponse(code=403, message="You do not have permission to join the room. A meaningful errcode and description error text will be returned."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @POST
    @RateLimit
    @Secured
    @Path(value="/rooms/{roomId}/join")
    public RoomId join(@ApiParam(value="The room identifier (not alias) to join.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="JSON body request") JoinRequest var2, @Context HttpServletRequest var3, @Context HttpServletResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="This API starts a user participating in a particular room, if that user is allowed to participate in that room. After this call, the client is allowed to see all current state events in the room, and all subsequent events associated with the room until the user leaves the room.", response=RoomId.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The room has been joined. The joined room ID must be returned in the room_id field."), @ApiResponse(code=403, message="You do not have permission to join the room. A meaningful errcode and description error text will be returned."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @POST
    @RateLimit
    @Secured
    @Path(value="/join/{roomIdOrAlias}")
    public RoomId joinByIdOrAlias(@ApiParam(value="The room identifier or alias to join.", required=true) @PathParam(value="roomIdOrAlias") String var1, @ApiParam(name="server_name", value="The servers to attempt to join the room through. One of the serversmust be participating in the room.") @QueryParam(value="server_name") List<String> var2, @ApiParam(value="JSON body request.") JoinRequest var3, @Context HttpServletRequest var4, @Context HttpServletResponse var5, @Context SecurityContext var6);

    @ApiOperation(value="This API stops a user participating in a particular room. If the user was already in the room, they will no longer be able to see new events in the room. If the room requires an invite to join, they will need to be re-invited before they can re-join. If the user was invited to the room, but had not joined, this call serves to reject the invite.The user will still be allowed to retrieve history from the room which they were previously allowed to see.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The room has been left."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @POST
    @RateLimit
    @Secured
    @Path(value="/rooms/{roomId}/leave")
    public EmptyResponse leave(@ApiParam(value="The room identifier to leave.", required=true) @PathParam(value="roomId") String var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3, @Context SecurityContext var4);

    @ApiOperation(value="This API stops a user remembering about a particular room. In general, history is a first class citizen in Matrix. After this API is called, however, a user will no longer be able to retrieve history for this room. If all users on a homeserver forget a room, the room is eligible for deletion from that homeserver.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The room has been forgotten."), @ApiResponse(code=400, message="The user has not left the room."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @POST
    @RateLimit
    @Secured
    @Path(value="/rooms/{roomId}/forget")
    public EmptyResponse forget(@ApiParam(value="The room identifier to forget.", required=true) @PathParam(value="roomId") String var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3, @Context SecurityContext var4);

    @ApiOperation(value="Kick a user from the room.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The user has been kicked from the room."), @ApiResponse(code=403, message="You do not have permission to kick the user from the room. A meaningful errcode and description error text will be returned.")})
    @POST
    @Secured
    @Path(value="/rooms/{roomId}/kick")
    public EmptyResponse kick(@ApiParam(value="The room identifier (not alias) from which the user should be kicked.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="JSON body request") KickRequest var2, @Context HttpServletRequest var3, @Context HttpServletResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="Ban a user in the room. If the user is currently in the room, also kick them.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The user has been kicked and banned from the room."), @ApiResponse(code=403, message="You do not have permission to ban the user from the room. A meaningful errcode and description error text will be returned.")})
    @POST
    @Secured
    @Path(value="/rooms/{roomId}/ban")
    public EmptyResponse ban(@ApiParam(value="The room identifier (not alias) from which the user should be banned.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="JSON body request.") KickRequest var2, @Context HttpServletRequest var3, @Context HttpServletResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="Unban a user from the room. This allows them to be invited to the room, and join if they would otherwise be allowed to join according to its join rules.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The user has been unbanned from the room."), @ApiResponse(code=403, message="You do not have permission to unban the user from the room. A meaningful errcode and description error text will be returned.")})
    @POST
    @Secured
    @Path(value="/rooms/{roomId}/unban")
    public EmptyResponse unban(@ApiParam(value="The room identifier (not alias) from which the user should be unbanned.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="JSON body request.") KickRequest var2, @Context HttpServletRequest var3, @Context HttpServletResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="Gets the visibility of a given room on the server's public room directory.", response=RoomVisibility.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The visibility of the room in the directory"), @ApiResponse(code=404, message="The room is not known to the server")})
    @GET
    @Path(value="/directory/list/room/{roomId}")
    public RoomVisibility getVisibility(@ApiParam(value="The room ID.", required=true) @PathParam(value="roomId") String var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3);

    @ApiOperation(value="Sets the visibility of a given room in the server's public room directory.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The visibility was updated, or no change was needed."), @ApiResponse(code=404, message="The room is not known to the server.")})
    @PUT
    @Secured
    @Path(value="/directory/list/room/{roomId}")
    public EmptyResponse setVisibility(@ApiParam(value="The room ID.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="JSON body request.") RoomVisibility var2, @Context HttpServletRequest var3, @Context HttpServletResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="Lists the public rooms on the server. This API returns paginated responses. The rooms are ordered by the number of joined members, with the largest rooms first.", response=PublicRoomsResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="A list of the rooms on the server.")})
    @GET
    @Path(value="/publicRooms")
    public PublicRoomsResponse showPublicRooms(@ApiParam(value="Limit the number of results returned.") @QueryParam(value="limit") Long var1, @ApiParam(value="A pagination token from a previous request, allowing clients to get the next (or previous) batch of rooms. The direction of pagination is specified solely by which token is supplied, rather than via an explicit flag.") @QueryParam(value="since") String var2, @ApiParam(value="The server to fetch the public room lists from. Defaults to the local server.") @QueryParam(value="server") String var3, @Context HttpServletRequest var4, @Context HttpServletResponse var5);

    @ApiOperation(value="Lists the public rooms on the server, with optional filter. This API returns paginated responses. The rooms are ordered by the number of joined members, with the largest rooms first.", response=PublicRoomsResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="A list of the rooms on the server.")})
    @POST
    @Secured
    @Path(value="/publicRooms")
    public PublicRoomsResponse searchPublicRooms(@ApiParam(value="The server to fetch the public room lists from. Defaults to the local server.") @QueryParam(value="server") String var1, @ApiParam(value="JSON body request.") PublicRoomsRequest var2, @Context HttpServletRequest var3, @Context HttpServletResponse var4, @Context SecurityContext var5);

    public static class Preset {
        public static final String PRIVATE_CHAT = "private_chat";
        public static final String PUBLIC_CHAT = "public_chat";
        public static final String TRUSTED_PRIVATE_CHAT = "trusted_private_chat";

        protected Preset() {
        }
    }

    public static class Visibility {
        public static final String PUBLIC = "public";
        public static final String PRIVATE = "private";

        protected Visibility() {
        }
    }
}

