/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.Secured;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="ClientConfig", description="Client Behaviour")
@Path(value="/_matrix/client/r0/user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface ClientConfigApi {
    @ApiOperation(value="Set some account_data for the client.", notes="This config is only visible to the user that set the account_data. The config will be synced to clients in the top-level account_data.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The account_data was successfully added.")})
    @PUT
    @Secured
    @Path(value="/{userId}/account_data/{type}")
    public EmptyResponse addConfig(@ApiParam(value="The id of the user to set account_data for. The access token must be authorized to make requests for this user id.", required=true) @PathParam(value="userId") String var1, @ApiParam(value="The event type of the account_data to set. Custom types should be namespaced to avoid clashes.", required=true) @PathParam(value="type") String var2, @ApiParam(value="Account data") Map<String, String> var3, @Context HttpServletRequest var4, @Context HttpServletResponse var5, @Context SecurityContext var6);

    @ApiOperation(value="Set some account_data for the client on a given room.", notes="This config is only visible to the user that set the account_data. The config will be synced to clients in the per-room account_data.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The account_data was successfully added.")})
    @PUT
    @Secured
    @Path(value="/{userId}/rooms/{roomId}/account_data/{type}")
    public EmptyResponse addRoomConfig(@ApiParam(value="The id of the user to set account_data for. The access token must be authorized to make requests for this user id.", required=true) @PathParam(value="userId") String var1, @ApiParam(value="The id of the room to set account_data on.", required=true) @PathParam(value="roomId") String var2, @ApiParam(value="The event type of the account_data to set. Custom types should be namespaced to avoid clashes.", required=true) @PathParam(value="type") String var3, @ApiParam(value="Account data") Map<String, String> var4, @Context HttpServletRequest var5, @Context HttpServletResponse var6, @Context SecurityContext var7);
}

