/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;

@Api(value="CAS", description="Central Authentication Service (CAS) is a web-based single sign-on protocol.")
@Path(value="/_matrix/client/r0/login/cas")
public interface CasApi {
    @ApiOperation(value="A web-based Matrix client should instruct the user's browser to navigate to this endpoint in order to log in via CAS.", notes="The server MUST respond with an HTTP redirect to the CAS interface. The URI MUST include a service parameter giving the path of the /login/cas/ticket endpoint (including the redirectUrl query parameter).", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=302, message="A redirect to the CAS interface")})
    @GET
    @Path(value="/redirect")
    public EmptyResponse redirect(@ApiParam(value="URI to which the user will be redirected after the homeserver has authenticated the user with CAS.", required=true) @QueryParam(value="redirectUrl") String var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3);

    @ApiOperation(value="Once the CAS server has authenticated the user, it will redirect the browser to this endpoint (assuming /login/cas/redirect gave it the correct service parameter).", notes="The server MUST call /proxyValidate on the CAS server, to validate the ticket supplied by the browser. If validation is successful, the server must generate a Matrix login token. It must then respond with an HTTP redirect to the URI given in the redirectUrl parameter, adding a loginToken query parameter giving the generated token. If validation is unsuccessful, the server should respond with a 401 Unauthorized error, the body of which will be displayed to the user.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=302, message="A redirect to the Matrix client."), @ApiResponse(code=401, message="The server was unable to validate the CAS ticket.")})
    @GET
    @Path(value="/ticket")
    public EmptyResponse ticket(@ApiParam(value="The redirectUrl originally provided by the client to /login/cas/redirect.", required=true) @QueryParam(value="redirectUrl") String var1, @ApiParam(value="CAS authentication ticket", required=true) @QueryParam(value="ticket") String var2, @Context HttpServletRequest var3, @Context HttpServletResponse var4);
}

