/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.bot;

import io.github.ma1uta.matrix.bot.Bot;
import io.github.ma1uta.matrix.bot.BotConfig;
import io.github.ma1uta.matrix.bot.BotDao;
import io.github.ma1uta.matrix.bot.Command;
import io.github.ma1uta.matrix.bot.PersistentService;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBotPool<C extends BotConfig, D extends BotDao<C>, S extends PersistentService<D>, E, B extends Bot<C, D, S, E>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBotPool.class);
    private final RequestFactory requestFactory;
    private final String displayName;
    private final S service;
    private final List<Class<? extends Command<C, D, S, E>>> commandClasses;
    private Map<String, B> botMap = new HashMap<String, B>();

    public AbstractBotPool(RequestFactory requestFactory, String displayName, S service, List<Class<? extends Command<C, D, S, E>>> commandClasses) {
        this.requestFactory = requestFactory;
        this.service = service;
        this.commandClasses = commandClasses;
        this.displayName = displayName;
    }

    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public S getService() {
        return this.service;
    }

    public List<Class<? extends Command<C, D, S, E>>> getCommandClasses() {
        return this.commandClasses;
    }

    public Map<String, B> getBotMap() {
        return this.botMap;
    }

    protected abstract C createConfig(String var1);

    protected abstract void initializeBot(Bot<C, D, S, E> var1);

    protected abstract B createBotInstance(C var1);

    protected abstract void submitBot(B var1);

    public void startNewBot(String username) {
        this.submit(this.createConfig(username));
    }

    protected void submit(C config) {
        ((PersistentService)this.getService()).invoke(dao -> dao.save(config));
        B bot = this.createBotInstance(config);
        this.initializeBot((Bot<C, D, S, E>)bot);
        String userId = ((BotConfig)((Bot)bot).getContext().getConfig()).getUserId();
        this.getBotMap().put(userId, bot);
        ((Bot)bot).getContext().addShutdownListener(() -> {
            this.getBotMap().remove(userId);
            return null;
        });
        this.submitBot(bot);
    }

    public void start() {
        ((PersistentService)this.getService()).invoke(dao -> dao.findAll().forEach(this::submit));
    }

    public void stop() throws InterruptedException {
    }
}

