/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.bot;

import io.github.ma1uta.matrix.bot.AbstractBotPool;
import io.github.ma1uta.matrix.bot.ApplicationServiceBot;
import io.github.ma1uta.matrix.bot.BotConfig;
import io.github.ma1uta.matrix.bot.BotDao;
import io.github.ma1uta.matrix.bot.BotState;
import io.github.ma1uta.matrix.bot.Command;
import io.github.ma1uta.matrix.bot.Context;
import io.github.ma1uta.matrix.bot.PersistentService;
import io.github.ma1uta.matrix.event.Event;
import io.github.ma1uta.matrix.event.RoomEvent;
import io.github.ma1uta.matrix.event.RoomMember;
import io.github.ma1uta.matrix.event.content.RoomMemberContent;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApplicationServiceBotPool<C extends BotConfig, D extends BotDao<C>, S extends PersistentService<D>, E>
extends AbstractBotPool<C, D, S, E, ApplicationServiceBot<C, D, S, E>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractApplicationServiceBotPool.class);
    private final String appToken;

    public AbstractApplicationServiceBotPool(String displayName, String appToken, S service, List<Class<? extends Command<C, D, S, E>>> commandClasses) {
        super(displayName, service, commandClasses);
        this.appToken = appToken;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public boolean send(String roomId, Event event) {
        LOGGER.debug("Receive event in the room: {0}", (Object)roomId);
        Optional<ApplicationServiceBot> bot = this.getBotMap().entrySet().stream().filter(entry -> {
            List joinedRooms;
            Context context = ((ApplicationServiceBot)entry.getValue()).getContext();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Bot \"{}\"", (Object)((BotConfig)context.getConfig()).getUserId());
            }
            try {
                joinedRooms = context.getMatrixClient().room().joinedRooms().getJoinedRooms();
            }
            catch (Exception e) {
                LOGGER.error("Cannot retrieve joined rooms.", (Throwable)e);
                return false;
            }
            if (LOGGER.isDebugEnabled()) {
                joinedRooms.forEach(joinedRoom -> LOGGER.debug("Room: {}", joinedRoom));
            }
            if (joinedRooms.contains(roomId)) {
                return true;
            }
            if (event instanceof RoomMember) {
                RoomMember roomMember = (RoomMember)event;
                String stateKey = roomMember.getStateKey();
                String membership = ((RoomMemberContent)roomMember.getContent()).getMembership();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Membership: {}", (Object)membership);
                    LOGGER.debug("Event type: {}", (Object)event.getType());
                    LOGGER.debug("State key: {}", (Object)stateKey);
                }
                return ((BotConfig)context.getConfig()).getUserId().equals(stateKey) && "invite".equals(membership);
            }
            return false;
        }).map(Map.Entry::getValue).findFirst();
        if (bot.isPresent() && event instanceof RoomEvent) {
            LOGGER.debug("Bot \"{}\" is found.", (Object)((BotConfig)bot.get().getContext().getConfig()).getUserId());
            bot.get().send((RoomEvent)event);
            return true;
        }
        LOGGER.debug("Bot didn't found.");
        return false;
    }

    @Override
    protected ApplicationServiceBot<C, D, S, E> createBotInstance(C config) {
        return new ApplicationServiceBot(this.getAppToken(), true, config, this.getService(), this.getCommandClasses());
    }

    @Override
    protected void submitBot(ApplicationServiceBot<C, D, S, E> bot) {
        if (BotState.NEW.equals((Object)((BotConfig)bot.getContext().getConfig()).getState())) {
            bot.newState();
        }
        bot.init();
    }
}

