/*
 * Decompiled with CFR 0.152.
 */
package com.rtmpx.library.yuv;

import android.media.Image;
import java.nio.ByteBuffer;

public class YuvFrame {
    private ByteBuffer y;
    private ByteBuffer u;
    private ByteBuffer v;
    private int yStride;
    private int uStride;
    private int vStride;
    private int width;
    private int height;

    public void fill(ByteBuffer y, ByteBuffer u, ByteBuffer v, int yStride, int uStride, int vStride, int width, int height) {
        this.y = y;
        this.u = u;
        this.v = v;
        this.yStride = yStride;
        this.uStride = uStride;
        this.vStride = vStride;
        this.width = width;
        this.height = height;
    }

    public void fill(Image image) {
        Image.Plane[] planes = image.getPlanes();
        Image.Plane yPlane = planes[0];
        this.y = yPlane.getBuffer();
        this.yStride = yPlane.getRowStride();
        Image.Plane uPlane = planes[1];
        this.u = uPlane.getBuffer();
        this.uStride = uPlane.getRowStride();
        Image.Plane vPlane = planes[2];
        this.v = vPlane.getBuffer();
        this.vStride = vPlane.getRowStride();
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public ByteBuffer getY() {
        return this.y;
    }

    public ByteBuffer getU() {
        return this.u;
    }

    public ByteBuffer getV() {
        return this.v;
    }

    public int getyStride() {
        return this.yStride;
    }

    public int getuStride() {
        return this.uStride;
    }

    public int getvStride() {
        return this.vStride;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] asArray() {
        byte[] array;
        int yPos = this.y.position();
        int uPos = this.u.position();
        int vPos = this.v.position();
        try {
            array = ByteBuffer.allocate(this.y.capacity() + this.u.capacity() + this.v.capacity()).put(this.y).put(this.u).put(this.v).array();
            this.y.position(yPos);
            this.u.position(uPos);
            this.v.position(vPos);
        }
        catch (Exception e) {
            array = new byte[this.size()];
            this.y.get(array, 0, this.y.remaining());
            this.y.position(yPos);
            this.u.get(array, this.y.remaining(), this.u.remaining());
            this.u.position(uPos);
            this.v.get(array, this.y.remaining() + this.u.remaining(), this.v.remaining());
            this.v.position(vPos);
        }
        return array;
    }

    public int size() {
        return this.y.remaining() + this.u.remaining() + this.v.remaining();
    }

    public void free() {
        this.y = ByteBuffer.allocate(1);
        this.u = ByteBuffer.allocate(1);
        this.v = ByteBuffer.allocate(1);
        this.yStride = 0;
        this.uStride = 0;
        this.vStride = 0;
        this.width = 0;
        this.height = 0;
    }
}

