/*
 * Decompiled with CFR 0.152.
 */
package com.rtmpx.library.publish;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.rtmpx.library.config.Config;
import com.rtmpx.library.encode.AudioEncoder;
import com.rtmpx.library.encode.Encoder;
import com.rtmpx.library.encode.VideoEncoder;
import com.rtmpx.library.publish.IPublishListener;
import com.rtmpx.library.record.video.VideoRecorder;
import com.rtmpx.library.rtmp.RTMPFrame;
import com.rtmpx.library.rtmp.RTMPMuxer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;

public class RTMPPublisher
implements Handler.Callback {
    private static final String TAG = "RTMPVRPublisher";
    private static final int MSG_WORK_START = 65280;
    private static final int MSG_START_PUBLISH = 65281;
    private static final int MSG_RTMP_CONNECTING = 0;
    private static final int MSG_RTMP_CONNECTED = 1;
    private static final int MSG_RTMP_CONNECTED_FAILED = 2;
    private static final int MSG_RTMP_START_PUBLISH = 3;
    private static final int MSG_RTMP_STOP_PUBLISH = 4;
    private static final int MSG_RTMP_START_RECORD = 5;
    private static final int MSG_RTMP_STOP_RECORD = 6;
    private static final int MSG_RTMP_FPS_STATISTIC = 7;
    private static final int MSG_RTMP_RELEASE = 8;
    private static final int MSG_RTMP_DISCONNECT = 9;
    private static volatile RTMPPublisher mInstance;
    private Config mConfig;
    private Queue<RTMPFrame> mFrameQueue = new ConcurrentLinkedDeque<RTMPFrame>();
    private HandlerThread mWorkThread;
    private Handler mWorkHandler;
    private Handler mCallbackHandler;
    private AtomicBoolean mThreadWorked = new AtomicBoolean(false);
    private AtomicBoolean mRTMPConnected = new AtomicBoolean(false);
    private RTMPMuxer mRtmpMuxer;
    private Encoder<byte[]> mVideoEncoder;
    private Encoder<byte[]> mAudioEncoder;
    private VideoRecorder mVideoRecorder;
    private long mLastTimestamp = 0L;
    private IPublishListener mPublishListener;
    private AtomicBoolean mInvokedPublish = new AtomicBoolean(false);
    private long mStartTime;
    private int mWriteCount;

    private RTMPPublisher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RTMPPublisher getInstance() {
        if (mInstance != null) return mInstance;
        Class<RTMPPublisher> clazz = RTMPPublisher.class;
        synchronized (RTMPPublisher.class) {
            if (mInstance != null) return mInstance;
            mInstance = new RTMPPublisher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    void setPublishListener(IPublishListener mPublishListener) {
        this.mPublishListener = mPublishListener;
    }

    private void checkWorkThread() {
        this.checkWorkThread(-1, null);
    }

    private void checkWorkThread(final int otherMessage, final Object obj) {
        if (null == this.mCallbackHandler) {
            this.mCallbackHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        }
        if (null == this.mWorkThread || !this.mWorkThread.isAlive() || this.mWorkThread.isInterrupted()) {
            this.mThreadWorked.set(false);
            this.mWorkThread = new HandlerThread("RTMPPublisher"){

                protected void onLooperPrepared() {
                    super.onLooperPrepared();
                    RTMPPublisher.this.mWorkHandler = new Handler(this.getLooper(), (Handler.Callback)RTMPPublisher.this);
                    RTMPPublisher.this.mWorkHandler.obtainMessage(65280).sendToTarget();
                    if (otherMessage > 0) {
                        RTMPPublisher.this.mWorkHandler.obtainMessage(otherMessage, obj).sendToTarget();
                    }
                }
            };
            this.mWorkThread.start();
        } else if (otherMessage > 0) {
            this.mWorkHandler.obtainMessage(otherMessage, obj).sendToTarget();
        }
    }

    private int checkRtmpConnection(Config vrConfig) {
        String publishUrl;
        if (null == this.mRtmpMuxer) {
            this.mRtmpMuxer = new RTMPMuxer();
        }
        if (TextUtils.isEmpty((CharSequence)(publishUrl = vrConfig.getPublishUrl()))) {
            Log.i((String)TAG, (String)"publish url is null");
            this.stopPublish();
            return -1;
        }
        Log.i((String)TAG, (String)("publishUrl is " + publishUrl));
        if (!this.mRTMPConnected.get()) {
            int status = this.mRtmpMuxer.open(publishUrl, vrConfig.getVideoWidth(), vrConfig.getVideoHeight(), this.mConfig.getFrameRate());
            return status;
        }
        return -1;
    }

    void startPublish(Config config) {
        this.mConfig = config;
        this.reset();
        if (null == this.mVideoEncoder) {
            this.mVideoEncoder = new VideoEncoder(config);
        }
        if (null == this.mAudioEncoder) {
            this.mAudioEncoder = new AudioEncoder(config);
        }
        this.checkWorkThread(65281, config);
    }

    void stopPublish() {
        this.release();
        if (null != this.mCallbackHandler) {
            this.mCallbackHandler.obtainMessage(4).sendToTarget();
        }
    }

    private void release() {
        this.reset();
        if (null != this.mWorkHandler) {
            this.mWorkHandler.obtainMessage(8).sendToTarget();
        }
    }

    private void reset() {
        this.mStartTime = 0L;
        this.mLastTimestamp = 0L;
        this.mWriteCount = 0;
        this.mThreadWorked.set(false);
        this.mInvokedPublish.set(false);
        if (null != this.mWorkHandler) {
            this.mWorkHandler.removeCallbacksAndMessages(null);
        }
        this.mFrameQueue.clear();
    }

    public void addFrame(RTMPFrame vrFrame) {
        this.mFrameQueue.add(vrFrame);
    }

    public void encodeVideo(byte[] data) {
        if (!this.isWorked()) {
            return;
        }
        if (null == this.mVideoEncoder) {
            Log.i((String)TAG, (String)"mVideoEncoder is null");
            return;
        }
        this.mVideoEncoder.encode(data);
    }

    public void encodeAudio(byte[] data) {
        if (!this.isWorked()) {
            return;
        }
        if (null == this.mAudioEncoder) {
            Log.i((String)TAG, (String)"mAudioEncoder is null");
            return;
        }
        this.mAudioEncoder.encode(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        Log.i((String)TAG, (String)("===========handleMessage============" + msg.what));
        switch (msg.what) {
            case 65280: {
                this.mThreadWorked.set(true);
                break;
            }
            case 65281: {
                this.mCallbackHandler.obtainMessage(0).sendToTarget();
                this.mFrameQueue.clear();
                Config config = (Config)msg.obj;
                Log.i((String)TAG, (String)("thread is " + Thread.currentThread()));
                int status = this.checkRtmpConnection(config);
                boolean connected = status > 0;
                this.mRTMPConnected.set(connected);
                if (!connected) {
                    Log.i((String)TAG, (String)("===========checkRtmpConnection not connected============" + status));
                }
                if (connected) {
                    this.mCallbackHandler.obtainMessage(1).sendToTarget();
                    long time = SystemClock.uptimeMillis();
                    this.mVideoEncoder.setStartTime(time);
                    this.mAudioEncoder.setStartTime(time);
                    this.mVideoEncoder.start();
                    this.mAudioEncoder.start();
                    this.startWrite();
                    break;
                }
                this.mCallbackHandler.obtainMessage(2, (Object)status).sendToTarget();
                break;
            }
            case 0: {
                if (null == this.mPublishListener) break;
                this.mPublishListener.onConnecting();
                break;
            }
            case 1: {
                if (null == this.mPublishListener) break;
                this.mPublishListener.onConnected();
                break;
            }
            case 2: {
                if (null != this.mPublishListener) {
                    this.mPublishListener.onConnectedFailed((Integer)msg.obj);
                }
                this.stopPublish();
                break;
            }
            case 3: {
                if (null == this.mPublishListener) break;
                this.mPublishListener.onStartPublish();
                break;
            }
            case 4: {
                if (null == this.mPublishListener) break;
                this.mPublishListener.onStopPublish();
                break;
            }
            case 5: {
                if (null == this.mPublishListener) break;
                this.mPublishListener.onStartRecord();
                break;
            }
            case 6: {
                if (null != this.mPublishListener) {
                    this.mPublishListener.onStopRecord();
                }
                this.mCallbackHandler.removeCallbacksAndMessages(null);
                break;
            }
            case 7: {
                if (null == this.mPublishListener) break;
                this.mPublishListener.onFpsStatistic((Integer)msg.obj);
                break;
            }
            case 9: {
                if (null == this.mPublishListener) break;
                this.mPublishListener.onRtmpDisconnect();
                break;
            }
            case 8: {
                try {
                    this.mVideoEncoder.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    this.mAudioEncoder.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.stopRecord();
                try {
                    if (this.mRTMPConnected.get()) {
                        this.mRtmpMuxer.close();
                        this.mRtmpMuxer = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (null == this.mWorkThread) break;
                    this.mWorkThread.quit();
                    this.mWorkThread.interrupt();
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
                finally {
                    this.mRTMPConnected.set(false);
                    this.mWorkThread = null;
                    this.mWorkHandler = null;
                    this.mVideoEncoder = null;
                    this.mAudioEncoder = null;
                    this.mVideoRecorder = null;
                }
            }
        }
        return false;
    }

    private void startRecord() {
        if (null != this.mAudioEncoder.getSps() && null != this.mVideoEncoder.getSps() && null != this.mVideoEncoder.getPps()) {
            try {
                String recordVideoPath = this.mConfig.getRecordVideoPath();
                if (null == this.mVideoRecorder) {
                    this.mVideoRecorder = new VideoRecorder(this.mConfig, this.mVideoEncoder.getSps(), this.mVideoEncoder.getPps(), this.mAudioEncoder.getSps());
                }
                if (!this.mVideoRecorder.isStart()) {
                    this.mVideoRecorder.startRecord(recordVideoPath);
                    if (null != this.mCallbackHandler) {
                        this.mCallbackHandler.obtainMessage(5).sendToTarget();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void stopRecord() {
        try {
            if (null == this.mVideoRecorder) {
                return;
            }
            this.mVideoRecorder.stopRecord();
            this.mVideoRecorder.release();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != this.mCallbackHandler) {
                this.mVideoRecorder = null;
                this.mCallbackHandler.obtainMessage(6).sendToTarget();
            }
        }
    }

    private void startWrite() {
        if (!this.isWorked()) {
            Log.i((String)TAG, (String)"rtmp not connected");
            return;
        }
        while (true) {
            if (!this.isWorked()) break;
            if (this.mFrameQueue.isEmpty()) {
                try {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        this.stopPublish();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {}
                continue;
            }
            RTMPFrame frame = this.mFrameQueue.poll();
            this.writeSample(frame);
        }
        Log.i((String)TAG, (String)"rtmp not worked");
    }

    public boolean isWorked() {
        return this.mThreadWorked.get() && null != this.mRtmpMuxer && this.mRTMPConnected.get();
    }

    public void writeSample(RTMPFrame frame) {
        if (null == frame || !this.isWorked()) {
            return;
        }
        if (null != this.mRtmpMuxer && !this.mRtmpMuxer.isConnected()) {
            Log.i((String)TAG, (String)"=========disconnect reconnect  =========");
            this.mCallbackHandler.obtainMessage(4).sendToTarget();
            this.mCallbackHandler.obtainMessage(9).sendToTarget();
            return;
        }
        byte[] data = frame.getData();
        int type = frame.getType();
        long offset = frame.getPresentationTimeUs();
        if (offset < this.mLastTimestamp && frame.getBufferInfo().flags != 2) {
            offset = this.mLastTimestamp;
        }
        Log.i((String)TAG, (String)("=========offset=========" + offset + " size is " + data.length));
        if (this.mConfig.isRecordVideo()) {
            this.startRecord();
        } else if (null != this.mVideoRecorder) {
            this.stopRecord();
        }
        if (0 == type) {
            if (0L == this.mStartTime) {
                this.mStartTime = System.currentTimeMillis();
            }
            if (!this.mInvokedPublish.get()) {
                this.mCallbackHandler.obtainMessage(3).sendToTarget();
                this.mInvokedPublish.set(true);
            }
            Log.i((String)TAG, (String)("=========writeVideo=========" + offset));
            ++this.mWriteCount;
            if (this.mWriteCount % this.mConfig.getFrameRate() == 0) {
                long countTime = System.currentTimeMillis() - this.mStartTime;
                long normalTime = 1000 / this.mConfig.getFrameRate() * this.mWriteCount;
                float scale = (float)normalTime / (float)countTime;
                Log.i((String)TAG, (String)("avgFPS scale == " + scale));
                int avgFPS = Math.round((float)this.mConfig.getFrameRate() * scale);
                this.mCallbackHandler.obtainMessage(7, (Object)avgFPS).sendToTarget();
            }
            if (null != this.mVideoRecorder) {
                this.mVideoRecorder.writeVideo(frame);
            }
            this.mRtmpMuxer.writeVideo(data, 0, data.length, offset);
        }
        if (1 == type) {
            Log.i((String)TAG, (String)("=========writeAudio=========" + offset));
            if (null != this.mVideoRecorder) {
                this.mVideoRecorder.writeAudio(frame);
            }
            this.mRtmpMuxer.writeAudio(data, 0, data.length, offset);
        }
        if (frame.getBufferInfo().flags != 2) {
            this.mLastTimestamp = offset;
        }
    }
}

