/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import io.grpc.Context;
import io.grpc.ServerInterceptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.aopalliance.intercept.MethodInvocation;
import org.lognet.springboot.grpc.GRpcServicesRegistry;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.lognet.springboot.grpc.security.AuthenticatedAttributeVoter;
import org.lognet.springboot.grpc.security.AuthenticationSchemeSelector;
import org.lognet.springboot.grpc.security.AuthenticationSchemeService;
import org.lognet.springboot.grpc.security.GrpcSecurityMetadataSource;
import org.lognet.springboot.grpc.security.GrpcServiceAuthorizationConfigurer;
import org.lognet.springboot.grpc.security.SecurityInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.ExpressionBasedAnnotationAttributeFactory;
import org.springframework.security.access.expression.method.ExpressionBasedPostInvocationAdvice;
import org.springframework.security.access.expression.method.ExpressionBasedPreInvocationAdvice;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.intercept.AfterInvocationManager;
import org.springframework.security.access.intercept.AfterInvocationProviderManager;
import org.springframework.security.access.method.DelegatingMethodSecurityMetadataSource;
import org.springframework.security.access.prepost.PostInvocationAdviceProvider;
import org.springframework.security.access.prepost.PostInvocationAuthorizationAdvice;
import org.springframework.security.access.prepost.PreInvocationAuthorizationAdvice;
import org.springframework.security.access.prepost.PreInvocationAuthorizationAdviceVoter;
import org.springframework.security.access.prepost.PrePostAnnotationSecurityMetadataSource;
import org.springframework.security.access.prepost.PrePostInvocationAttributeFactory;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.AbstractConfiguredSecurityBuilder;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetailsService;

public class GrpcSecurity
extends AbstractConfiguredSecurityBuilder<ServerInterceptor, GrpcSecurity>
implements SecurityBuilder<ServerInterceptor>,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    public static final Context.Key<Authentication> AUTHENTICATION_CONTEXT_KEY = Context.key((String)"AUTHENTICATION");

    public GrpcSecurity(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    public GrpcServiceAuthorizationConfigurer.Registry authorizeRequests() throws Exception {
        return this.getOrApply(new GrpcServiceAuthorizationConfigurer((GRpcServicesRegistry)this.applicationContext.getBean(GRpcServicesRegistry.class))).getRegistry();
    }

    public GrpcSecurity userDetailsService(UserDetailsService userDetailsService) throws Exception {
        this.getAuthenticationRegistry().userDetailsService(userDetailsService);
        return this;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public GrpcSecurity authenticationSchemeSelector(AuthenticationSchemeSelector selector) {
        this.getAuthenticationSchemeService().register(selector);
        return this;
    }

    public GrpcSecurity authenticationProvider(AuthenticationProvider authenticationProvider) {
        this.getAuthenticationRegistry().authenticationProvider(authenticationProvider);
        return this;
    }

    protected void beforeConfigure() throws Exception {
    }

    protected ServerInterceptor performBuild() throws Exception {
        GrpcSecurityMetadataSource metadataSource = (GrpcSecurityMetadataSource)this.getSharedObject(GrpcSecurityMetadataSource.class);
        DefaultMethodSecurityExpressionHandler methodSecurityExpressionHandler = new DefaultMethodSecurityExpressionHandler();
        methodSecurityExpressionHandler.setApplicationContext(this.getApplicationContext());
        DelegatingMethodSecurityMetadataSource compositeMDS = new DelegatingMethodSecurityMetadataSource(Arrays.asList(metadataSource, new PrePostAnnotationSecurityMetadataSource((PrePostInvocationAttributeFactory)new ExpressionBasedAnnotationAttributeFactory((MethodSecurityExpressionHandler)methodSecurityExpressionHandler))));
        SecurityInterceptor securityInterceptor = new SecurityInterceptor((SecurityMetadataSource)compositeMDS, this.getAuthenticationSchemeService());
        securityInterceptor.setAfterInvocationManager(this.afterInvocationManager());
        securityInterceptor.setAuthenticationManager((AuthenticationManager)((AuthenticationManagerBuilder)this.getSharedObject(AuthenticationManagerBuilder.class)).build());
        RoleVoter scopeVoter = new RoleVoter();
        scopeVoter.setRolePrefix("SCOPE_");
        ExpressionBasedPreInvocationAdvice expressionAdvice = new ExpressionBasedPreInvocationAdvice();
        expressionAdvice.setExpressionHandler((MethodSecurityExpressionHandler)methodSecurityExpressionHandler);
        AffirmativeBased accessDecisionManager = new AffirmativeBased(Arrays.asList(new RoleVoter(), scopeVoter, new AuthenticatedAttributeVoter(), new PreInvocationAuthorizationAdviceVoter((PreInvocationAuthorizationAdvice)expressionAdvice){

            public int vote(Authentication authentication, MethodInvocation method, Collection<ConfigAttribute> attributes) {
                return null == method.getArguments() ? 0 : super.vote(authentication, method, attributes);
            }
        }));
        accessDecisionManager.setAllowIfAllAbstainDecisions(true);
        securityInterceptor.setAccessDecisionManager((AccessDecisionManager)accessDecisionManager);
        GRpcServerProperties.SecurityProperties.Auth authCfg = Optional.of((GRpcServerProperties)this.applicationContext.getBean(GRpcServerProperties.class)).map(GRpcServerProperties::getSecurity).map(GRpcServerProperties.SecurityProperties::getAuth).orElse(null);
        securityInterceptor.setConfig(authCfg);
        return securityInterceptor;
    }

    private <C extends SecurityConfigurerAdapter<ServerInterceptor, GrpcSecurity>> C getOrApply(C configurer) throws Exception {
        SecurityConfigurerAdapter existingConfig = (SecurityConfigurerAdapter)this.getConfigurer(configurer.getClass());
        if (existingConfig != null) {
            return (C)existingConfig;
        }
        return (C)this.apply(configurer);
    }

    private AuthenticationManagerBuilder getAuthenticationRegistry() {
        return (AuthenticationManagerBuilder)this.getSharedObject(AuthenticationManagerBuilder.class);
    }

    private AuthenticationSchemeService getAuthenticationSchemeService() {
        return (AuthenticationSchemeService)this.getSharedObject(AuthenticationSchemeService.class);
    }

    protected AfterInvocationManager afterInvocationManager() {
        AfterInvocationProviderManager invocationProviderManager = new AfterInvocationProviderManager();
        ExpressionBasedPostInvocationAdvice postAdvice = new ExpressionBasedPostInvocationAdvice((MethodSecurityExpressionHandler)new DefaultMethodSecurityExpressionHandler());
        PostInvocationAdviceProvider postInvocationAdviceProvider = new PostInvocationAdviceProvider((PostInvocationAuthorizationAdvice)postAdvice);
        invocationProviderManager.setProviders(Arrays.asList(postInvocationAdviceProvider));
        invocationProviderManager.afterPropertiesSet();
        return invocationProviderManager;
    }
}

