/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.lognet.springboot.grpc.security.AuthenticationSchemeSelector;
import org.lognet.springboot.grpc.security.GrpcSecurity;
import org.lognet.springboot.grpc.security.GrpcSecurityMetadataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityInterceptor
extends AbstractSecurityInterceptor
implements ServerInterceptor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(SecurityInterceptor.class);
    private GrpcSecurityMetadataSource securedMethods;
    private AuthenticationSchemeSelector schemeSelector;

    public SecurityInterceptor(GrpcSecurityMetadataSource securedMethods, AuthenticationSchemeSelector schemeSelector) {
        this.securedMethods = securedMethods;
        this.schemeSelector = schemeSelector;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Class<?> getSecureObjectClass() {
        return MethodDescriptor.class;
    }

    public GrpcSecurityMetadataSource obtainSecurityMetadataSource() {
        return this.securedMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        byte[] authorization = (byte[])headers.get(Metadata.Key.of((String)"Authorization-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER));
        Authentication authentication = null == authorization ? null : this.schemeSelector.getAuthScheme(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(authorization))).orElseThrow(() -> new RuntimeException("Can't get authentication from authorization header"));
        try {
            SecurityContext context = SecurityContextHolder.createEmptyContext();
            context.setAuthentication(authentication);
            SecurityContextHolder.setContext((SecurityContext)context);
            this.beforeInvocation(call.getMethodDescriptor());
            Context ctx = Context.current().withValue(GrpcSecurity.AUTHENTICATION_CONTEXT_KEY, (Object)SecurityContextHolder.getContext().getAuthentication());
            ServerCall.Listener listener = Contexts.interceptCall((Context)ctx, call, (Metadata)headers, next);
            return listener;
        }
        catch (Exception e) {
            call.close(Status.UNAUTHENTICATED.withDescription(e.getMessage()), new Metadata());
            ServerCall.Listener listener = new ServerCall.Listener<ReqT>(){};
            return listener;
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(null);
        }
    }
}

