/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure.consul;

import com.ecwid.consul.v1.agent.model.NewService;
import org.lognet.springboot.grpc.context.GRpcServerInitializedEvent;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.serviceregistry.ConsulAutoRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;

public class GrpcConsulRegistrar
implements SmartLifecycle {
    private ConsulRegistration registration;
    private ConsulServiceRegistry consulServiceRegistry;

    public GrpcConsulRegistrar(ConsulServiceRegistry consulServiceRegistry) {
        this.consulServiceRegistry = consulServiceRegistry;
    }

    @EventListener
    public void onGrpcServerStarted(GRpcServerInitializedEvent initializedEvent) {
        this.registration = this.getRegistration(initializedEvent);
        this.consulServiceRegistry.register(this.registration);
    }

    private ConsulRegistration getRegistration(GRpcServerInitializedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        ConsulDiscoveryProperties properties = (ConsulDiscoveryProperties)applicationContext.getBean(ConsulDiscoveryProperties.class);
        NewService grpcService = new NewService();
        grpcService.setPort(Integer.valueOf(event.getServer().getPort()));
        if (!properties.isPreferAgentAddress()) {
            grpcService.setAddress(properties.getHostname());
        }
        String appName = "grpc-" + ConsulAutoRegistration.getAppName((ConsulDiscoveryProperties)properties, (Environment)applicationContext.getEnvironment());
        grpcService.setName(ConsulAutoRegistration.normalizeForDns((String)appName));
        grpcService.setId("grpc-" + ConsulAutoRegistration.getInstanceId((ConsulDiscoveryProperties)properties, (ApplicationContext)applicationContext));
        return new ConsulRegistration(grpcService, properties);
    }

    public boolean isAutoStartup() {
        return false;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
    }

    public synchronized void stop() {
        this.consulServiceRegistry.deregister(this.registration);
        this.consulServiceRegistry.close();
        this.registration = null;
    }

    public synchronized boolean isRunning() {
        return null != this.registration;
    }

    public int getPhase() {
        return 0;
    }
}

