/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.context;

import java.util.HashMap;
import java.util.Map;
import org.lognet.springboot.grpc.context.GRpcServerInitializedEvent;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class GRpcServerPortInfoApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(final ConfigurableApplicationContext applicationContext) {
        applicationContext.addApplicationListener((ApplicationListener)new ApplicationListener<GRpcServerInitializedEvent>(){

            public void onApplicationEvent(GRpcServerInitializedEvent event) {
                GRpcServerPortInfoApplicationContextInitializer.this.onApplicationEvent(applicationContext, event);
            }
        });
    }

    private void onApplicationEvent(ConfigurableApplicationContext applicationContext, GRpcServerInitializedEvent event) {
        MutablePropertySources sources = applicationContext.getEnvironment().getPropertySources();
        PropertySource source = sources.get("server.ports");
        if (source == null) {
            source = new MapPropertySource("server.ports", new HashMap());
            sources.addFirst(source);
        }
        ((Map)source.getSource()).put("local.grpc.port", event.getServer().getPort());
    }
}

