/*
 * Decompiled with CFR 0.152.
 */
package me.leavestyle.handler;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.leavestyle.common.JsonUtils;
import me.leavestyle.handler.StrAbstractCacheHandler;
import me.leavestyle.handler.StrCacheFunUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrStrCacheHandler<K, V>
extends StrAbstractCacheHandler<K, List<V>, V> {
    private static final Logger log = LoggerFactory.getLogger(ArrStrCacheHandler.class);
    protected final Class<V> initValueType;

    @Override
    protected Map<K, List<V>> fetchFromCache(List<K> keys) {
        return StrCacheFunUtils.fetchFromCache(keys, this, cacheValue -> JsonUtils.toListObjWithDefault(cacheValue, this.initValueType));
    }

    @Override
    protected Map<K, List<V>> fetchFromDb(List<K> keys) {
        return StrCacheFunUtils.fetchFromDb(keys, this, dbData -> dbData.stream().collect(Collectors.groupingBy(this.reDbGroupFun)));
    }

    @Override
    protected void writeToCache(List<K> unCachedKeys, Map<K, List<V>> dbData) {
        StrCacheFunUtils.writeToCache(unCachedKeys, dbData, CollectionUtils::isEmpty, this);
    }

    @Override
    protected List<V> mergeData(List<K> keys, Map<K, List<V>> cachedDb, Map<K, List<V>> dbData) {
        return keys.stream().map(key -> (List)cachedDb.getOrDefault(key, (List)dbData.get(key))).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected ArrStrCacheHandler(ArrStrCacheHandlerBuilder<K, V, ?, ?> b) {
        super(b);
        this.initValueType = ((ArrStrCacheHandlerBuilder)b).initValueType;
    }

    public static <K, V> ArrStrCacheHandlerBuilder<K, V, ?, ?> builder() {
        return new ArrStrCacheHandlerBuilderImpl();
    }

    public ArrStrCacheHandlerBuilder<K, V, ?, ?> toBuilder() {
        return new ArrStrCacheHandlerBuilderImpl().$fillValuesFrom(this);
    }

    private static final class ArrStrCacheHandlerBuilderImpl<K, V>
    extends ArrStrCacheHandlerBuilder<K, V, ArrStrCacheHandler<K, V>, ArrStrCacheHandlerBuilderImpl<K, V>> {
        private ArrStrCacheHandlerBuilderImpl() {
        }

        @Override
        protected ArrStrCacheHandlerBuilderImpl<K, V> self() {
            return this;
        }

        @Override
        public ArrStrCacheHandler<K, V> build() {
            return new ArrStrCacheHandler(this);
        }
    }

    public static abstract class ArrStrCacheHandlerBuilder<K, V, C extends ArrStrCacheHandler<K, V>, B extends ArrStrCacheHandlerBuilder<K, V, C, B>>
    extends StrAbstractCacheHandler.StrAbstractCacheHandlerBuilder<K, List<V>, V, C, B> {
        private Class<V> initValueType;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ArrStrCacheHandlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static <K, V> void $fillValuesFromInstanceIntoBuilder(ArrStrCacheHandler<K, V> instance, ArrStrCacheHandlerBuilder<K, V, ?, ?> b) {
            b.initValueType(instance.initValueType);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public B initValueType(Class<V> initValueType) {
            this.initValueType = initValueType;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ArrStrCacheHandler.ArrStrCacheHandlerBuilder(super=" + super.toString() + ", initValueType=" + this.initValueType + ")";
        }
    }
}

