/*
 * Decompiled with CFR 0.152.
 */
package me.leavestyle.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    JsonUtils() {
    }

    public static <T> List<T> toListObj(String json, Class<T> type) throws JsonProcessingException {
        CollectionType collectionType = OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, type);
        return (List)OBJECT_MAPPER.readValue(json, (JavaType)collectionType);
    }

    public static <T> T toObj(String json, Class<T> type) throws JsonProcessingException {
        return (T)OBJECT_MAPPER.readValue(json, type);
    }

    public static String toJsonStr(Object obj) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString(obj);
    }

    public static <T> List<T> toListObjWithDefault(String json, Class<T> type) {
        try {
            return JsonUtils.toListObj(json, type);
        }
        catch (JsonProcessingException e) {
            JsonUtils.logError(json);
            return null;
        }
    }

    public static <T> T toObjWithDefault(String json, Class<T> type) {
        try {
            return JsonUtils.toObj(json, type);
        }
        catch (JsonProcessingException e) {
            JsonUtils.logError(json);
            return null;
        }
    }

    private static void logError(String json) {
        log.error("convert json : {} to obj error", (Object)json);
    }
}

