/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.trigger.properties;

import com.novemberain.quartz.mongodb.trigger.TriggerPropertiesConverter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.quartz.DailyTimeIntervalTrigger;
import org.quartz.DateBuilder;
import org.quartz.TimeOfDay;
import org.quartz.impl.triggers.DailyTimeIntervalTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class DailyTimeIntervalTriggerPropertiesConverter
extends TriggerPropertiesConverter {
    private static final String TRIGGER_REPEAT_INTERVAL_UNIT = "repeatIntervalUnit";
    private static final String TRIGGER_REPEAT_INTERVAL = "repeatInterval";
    private static final String TRIGGER_TIMES_TRIGGERED = "timesTriggered";
    private static final String TRIGGER_START_TIME_OF_DAY = "startTimeOfDay";
    private static final String TRIGGER_END_TIME_OF_DAY = "endTimeOfDay";
    private static final String TRIGGER_DAYS_OF_WEEK = "daysOfWeek";

    @Override
    protected boolean canHandle(OperableTrigger trigger) {
        return trigger instanceof DailyTimeIntervalTrigger && !((DailyTimeIntervalTriggerImpl)trigger).hasAdditionalProperties();
    }

    @Override
    public Document injectExtraPropertiesForInsert(OperableTrigger trigger, Document original) {
        DailyTimeIntervalTriggerImpl t = (DailyTimeIntervalTriggerImpl)trigger;
        return new Document((Map)original).append(TRIGGER_REPEAT_INTERVAL_UNIT, (Object)t.getRepeatIntervalUnit().name()).append(TRIGGER_REPEAT_INTERVAL, (Object)t.getRepeatInterval()).append(TRIGGER_TIMES_TRIGGERED, (Object)t.getTimesTriggered()).append(TRIGGER_START_TIME_OF_DAY, (Object)this.toDocument(t.getStartTimeOfDay())).append(TRIGGER_END_TIME_OF_DAY, (Object)this.toDocument(t.getEndTimeOfDay())).append(TRIGGER_DAYS_OF_WEEK, new ArrayList(t.getDaysOfWeek()));
    }

    private Document toDocument(TimeOfDay tod) {
        return new Document().append("hour", (Object)tod.getHour()).append("minute", (Object)tod.getMinute()).append("second", (Object)tod.getSecond());
    }

    @Override
    public void setExtraPropertiesAfterInstantiation(OperableTrigger trigger, Document stored) {
        List daysOfWeek;
        Document endTOD;
        Document startTOD;
        Integer timesTriggered;
        Integer repeatInterval;
        DailyTimeIntervalTriggerImpl t = (DailyTimeIntervalTriggerImpl)trigger;
        String interval_unit = stored.getString((Object)TRIGGER_REPEAT_INTERVAL_UNIT);
        if (interval_unit != null) {
            t.setRepeatIntervalUnit(DateBuilder.IntervalUnit.valueOf((String)interval_unit));
        }
        if ((repeatInterval = stored.getInteger((Object)TRIGGER_REPEAT_INTERVAL)) != null) {
            t.setRepeatInterval(repeatInterval.intValue());
        }
        if ((timesTriggered = stored.getInteger((Object)TRIGGER_TIMES_TRIGGERED)) != null) {
            t.setTimesTriggered(timesTriggered.intValue());
        }
        if ((startTOD = (Document)stored.get((Object)TRIGGER_START_TIME_OF_DAY)) != null) {
            t.setStartTimeOfDay(this.fromDocument(startTOD));
        }
        if ((endTOD = (Document)stored.get((Object)TRIGGER_END_TIME_OF_DAY)) != null) {
            t.setEndTimeOfDay(this.fromDocument(endTOD));
        }
        if ((daysOfWeek = stored.getList((Object)TRIGGER_DAYS_OF_WEEK, Integer.class)) != null) {
            t.setDaysOfWeek(new HashSet(daysOfWeek));
        }
    }

    private TimeOfDay fromDocument(Document tod) {
        return new TimeOfDay(tod.getInteger((Object)"hour").intValue(), tod.getInteger((Object)"minute").intValue(), tod.getInteger((Object)"second").intValue());
    }
}

