/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.cluster;

import com.mongodb.MongoException;
import com.novemberain.quartz.mongodb.dao.SchedulerDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckinTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CheckinTask.class);
    private SchedulerDao schedulerDao;
    private Runnable errorhandler;

    public CheckinTask(SchedulerDao schedulerDao, Runnable errorHandler) {
        this.schedulerDao = schedulerDao;
        this.errorhandler = errorHandler;
    }

    public void setErrorHandler(Runnable errorHandler) {
        this.errorhandler = errorHandler;
    }

    @Override
    public void run() {
        log.debug("Node {}:{} checks-in.", (Object)this.schedulerDao.schedulerName, (Object)this.schedulerDao.instanceId);
        try {
            this.schedulerDao.checkIn();
        }
        catch (MongoException e) {
            log.error("Node " + this.schedulerDao.instanceId + " could not check-in: " + e.getMessage(), (Throwable)e);
            this.errorhandler.run();
        }
    }
}

