/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.cluster;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckinExecutor {
    private static final Logger log = LoggerFactory.getLogger(CheckinExecutor.class);
    private static final int INITIAL_DELAY = 0;
    private final Runnable checkinTask;
    private final long checkinIntervalMillis;
    private final String instanceId;
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);

    public CheckinExecutor(Runnable checkinTask, long checkinIntervalMillis, String instanceId) {
        this.checkinTask = checkinTask;
        this.checkinIntervalMillis = checkinIntervalMillis;
        this.instanceId = instanceId;
    }

    public void start() {
        log.info("Starting check-in task for scheduler instance: {}", (Object)this.instanceId);
        this.executor.scheduleAtFixedRate(this.checkinTask, 0L, this.checkinIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        log.info("Stopping CheckinExecutor for scheduler instance: {}", (Object)this.instanceId);
        this.executor.shutdown();
    }
}

