/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.util;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.novemberain.quartz.mongodb.util.QueryHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.quartz.impl.matchers.GroupMatcher;

public class GroupHelper {
    protected MongoCollection<Document> collection;
    protected QueryHelper queryHelper;

    public GroupHelper(MongoCollection<Document> collection, QueryHelper queryHelper) {
        this.collection = collection;
        this.queryHelper = queryHelper;
    }

    public Set<String> groupsThatMatch(GroupMatcher<?> matcher) {
        Bson filter = this.queryHelper.matchingKeysConditionFor(matcher);
        return (Set)this.collection.distinct("keyGroup", String.class).filter(filter).into(new HashSet());
    }

    public List<Document> inGroupsThatMatch(GroupMatcher<?> matcher) {
        return (List)this.collection.find(Filters.in((String)"keyGroup", this.groupsThatMatch(matcher))).into(new LinkedList());
    }

    public Set<String> allGroups() {
        return (Set)this.collection.distinct("keyGroup", String.class).into(new HashSet());
    }
}

