/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.dao;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public class PausedJobGroupsDao {
    private MongoCollection<Document> pausedJobGroupsCollection;

    public PausedJobGroupsDao(MongoCollection<Document> pausedJobGroupsCollection) {
        this.pausedJobGroupsCollection = pausedJobGroupsCollection;
    }

    public HashSet<String> getPausedGroups() {
        return (HashSet)this.pausedJobGroupsCollection.distinct("keyGroup", String.class).into(new HashSet());
    }

    public void pauseGroups(List<String> groups) {
        if (groups == null) {
            throw new IllegalArgumentException("groups cannot be null!");
        }
        ArrayList<Document> list = new ArrayList<Document>();
        for (String s : groups) {
            list.add(new Document("keyGroup", (Object)s));
        }
        this.pausedJobGroupsCollection.insertMany(list);
    }

    public void remove() {
        this.pausedJobGroupsCollection.deleteMany((Bson)new Document());
    }

    public void unpauseGroups(Collection<String> groups) {
        this.pausedJobGroupsCollection.deleteMany(Filters.in((String)"keyGroup", groups));
    }
}

