/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.novemberain.quartz.mongodb.Constants;
import com.novemberain.quartz.mongodb.MongoStoreAssembler;
import com.novemberain.quartz.mongodb.db.MongoConnector;
import com.novemberain.quartz.mongodb.util.Keys;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredResult;

public class MongoDBJobStore
implements JobStore,
Constants {
    private MongoStoreAssembler assembler = new MongoStoreAssembler();
    MongoConnector mongoConnector;
    MongoDatabase mongoDatabase;
    MongoClient mongo;
    String collectionPrefix = "quartz_";
    String dbName;
    String authDbName;
    String schedulerName;
    String instanceId;
    String[] addresses;
    String mongoUri;
    String username;
    String password;
    long misfireThreshold = 5000L;
    long triggerTimeoutMillis = 600000L;
    long jobTimeoutMillis = 600000L;
    private boolean clustered = false;
    long clusterCheckinIntervalMillis = 7500L;
    boolean jobDataAsBase64 = true;
    String checkInErrorHandler = null;
    Boolean mongoOptionSocketKeepAlive;
    Integer mongoOptionMaxConnections;
    Integer mongoOptionConnectTimeoutMillis;
    Integer mongoOptionReadTimeoutMillis;
    Boolean mongoOptionEnableSSL;
    Boolean mongoOptionSslInvalidHostNameAllowed;
    String mongoOptionTrustStorePath;
    String mongoOptionTrustStorePassword;
    String mongoOptionTrustStoreType;
    String mongoOptionKeyStorePath;
    String mongoOptionKeyStorePassword;
    String mongoOptionKeyStoreType;
    int mongoOptionWriteConcernTimeoutMillis = 5000;
    String mongoOptionWriteConcernW;
    public static final String PROPERTIES_FILE_NAME = "quartz.properties";

    public MongoDBJobStore() {
    }

    public MongoDBJobStore(MongoConnector mongoConnector) {
        this.mongoConnector = mongoConnector;
    }

    public MongoDBJobStore(MongoDatabase mongoDatabase) {
        this.mongoDatabase = mongoDatabase;
    }

    public MongoDBJobStore(MongoClient mongo) {
        this.mongo = mongo;
    }

    public MongoDBJobStore(String mongoUri, String username, String password) {
        this.mongoUri = mongoUri;
        this.username = username;
        this.password = password;
    }

    protected ClassLoadHelper getClassLoaderHelper(ClassLoadHelper original) {
        return original;
    }

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        Properties props = this.loadProperties(loadHelper);
        try {
            this.assembler.build(this, loadHelper, signaler, props);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SchedulerConfigException("Failed to instantiate cluster checkin error handler", (Throwable)e);
        }
        if (this.isClustered()) {
            try {
                this.assembler.triggerRecoverer.recover();
            }
            catch (JobPersistenceException e) {
                throw new SchedulerConfigException("Cannot recover triggers", (Throwable)e);
            }
            this.assembler.checkinExecutor.start();
        }
        this.ensureIndexes();
    }

    private Properties loadProperties(ClassLoadHelper loadHelper) {
        Properties props = new Properties();
        File propFile = new File(PROPERTIES_FILE_NAME);
        InputStream is = null;
        try {
            if (propFile.exists()) {
                is = new BufferedInputStream(new FileInputStream(PROPERTIES_FILE_NAME));
                props.load(is);
            } else {
                is = loadHelper.getClassLoader().getResourceAsStream(PROPERTIES_FILE_NAME);
                if (is != null) {
                    props.load(is);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    public void schedulerStarted() throws SchedulerException {
    }

    public void schedulerPaused() {
    }

    public void schedulerResumed() {
    }

    public void shutdown() {
        this.assembler.checkinExecutor.shutdown();
        this.assembler.mongoConnector.close();
    }

    public boolean supportsPersistence() {
        return true;
    }

    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return 200L;
    }

    public long getAcquireRetryDelay(int failureCount) {
        return this.mongo.getClusterDescription().getClusterSettings().getServerSelectionTimeout(TimeUnit.MILLISECONDS);
    }

    public void setIsClustered(boolean isClustered) {
        this.clustered = isClustered;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClusterCheckinInterval(long clusterCheckinInterval) {
        this.clusterCheckinIntervalMillis = clusterCheckinInterval;
    }

    public boolean isJobDataAsBase64() {
        return this.jobDataAsBase64;
    }

    public void setJobDataAsBase64(boolean jobDataAsBase64) {
        this.jobDataAsBase64 = jobDataAsBase64;
    }

    public String getCheckInErrorHandler() {
        return this.checkInErrorHandler;
    }

    public void setCheckInErrorHandler(String checkInErrorHandler) {
        this.checkInErrorHandler = checkInErrorHandler;
    }

    public void storeJobAndTrigger(JobDetail newJob, OperableTrigger newTrigger) throws JobPersistenceException {
        this.assembler.persister.storeJobAndTrigger(newJob, newTrigger);
    }

    public void storeJob(JobDetail newJob, boolean replaceExisting) throws JobPersistenceException {
        this.assembler.jobDao.storeJobInMongo(newJob, replaceExisting);
    }

    public void storeJobsAndTriggers(Map<JobDetail, Set<? extends Trigger>> triggersAndJobs, boolean replace) throws JobPersistenceException {
        for (Map.Entry<JobDetail, Set<? extends Trigger>> entry : triggersAndJobs.entrySet()) {
            JobDetail newJob = entry.getKey();
            Set<? extends Trigger> triggers = entry.getValue();
            this.assembler.jobDao.storeJobInMongo(newJob, replace);
            for (Trigger trigger : triggers) {
                this.assembler.persister.storeTrigger((OperableTrigger)trigger, replace);
            }
        }
    }

    public boolean removeJob(JobKey jobKey) throws JobPersistenceException {
        return this.assembler.persister.removeJob(jobKey);
    }

    public boolean removeJobs(List<JobKey> jobKeys) throws JobPersistenceException {
        return this.assembler.persister.removeJobs(jobKeys);
    }

    public JobDetail retrieveJob(JobKey jobKey) throws JobPersistenceException {
        return this.assembler.jobDao.retrieveJob(jobKey);
    }

    public void storeTrigger(OperableTrigger newTrigger, boolean replaceExisting) throws JobPersistenceException {
        this.assembler.persister.storeTrigger(newTrigger, replaceExisting);
    }

    public boolean removeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        return this.assembler.persister.removeTrigger(triggerKey);
    }

    public boolean removeTriggers(List<TriggerKey> triggerKeys) throws JobPersistenceException {
        return this.assembler.persister.removeTriggers(triggerKeys);
    }

    public boolean replaceTrigger(TriggerKey triggerKey, OperableTrigger newTrigger) throws JobPersistenceException {
        return this.assembler.persister.replaceTrigger(triggerKey, newTrigger);
    }

    public OperableTrigger retrieveTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        return this.assembler.triggerDao.getTrigger(triggerKey);
    }

    public boolean checkExists(JobKey jobKey) throws JobPersistenceException {
        return this.assembler.jobDao.exists(jobKey);
    }

    public boolean checkExists(TriggerKey triggerKey) throws JobPersistenceException {
        return this.assembler.triggerDao.exists(Keys.toFilter(triggerKey));
    }

    public void clearAllSchedulingData() throws JobPersistenceException {
        this.assembler.jobDao.clear();
        this.assembler.triggerDao.clear();
        this.assembler.calendarDao.clear();
        this.assembler.pausedJobGroupsDao.remove();
        this.assembler.pausedTriggerGroupsDao.remove();
    }

    public void storeCalendar(String name, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws JobPersistenceException {
        if (updateTriggers) {
            throw new UnsupportedOperationException("Updating triggers is not supported.");
        }
        this.assembler.calendarDao.store(name, calendar);
    }

    public boolean removeCalendar(String calName) throws JobPersistenceException {
        return this.assembler.calendarDao.remove(calName);
    }

    public Calendar retrieveCalendar(String calName) throws JobPersistenceException {
        return this.assembler.calendarDao.retrieveCalendar(calName);
    }

    public int getNumberOfJobs() throws JobPersistenceException {
        return this.assembler.jobDao.getCount();
    }

    public int getNumberOfTriggers() throws JobPersistenceException {
        return this.assembler.triggerDao.getCount();
    }

    public int getNumberOfCalendars() throws JobPersistenceException {
        return this.assembler.calendarDao.getCount();
    }

    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        return this.assembler.jobDao.getJobKeys(matcher);
    }

    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        return this.assembler.triggerDao.getTriggerKeys(matcher);
    }

    public List<String> getJobGroupNames() throws JobPersistenceException {
        return this.assembler.jobDao.getGroupNames();
    }

    public List<String> getTriggerGroupNames() throws JobPersistenceException {
        return this.assembler.triggerDao.getGroupNames();
    }

    public List<String> getCalendarNames() throws JobPersistenceException {
        return this.assembler.calendarDao.retrieveCalendarNames();
    }

    public List<OperableTrigger> getTriggersForJob(JobKey jobKey) throws JobPersistenceException {
        return this.assembler.persister.getTriggersForJob(jobKey);
    }

    public Trigger.TriggerState getTriggerState(TriggerKey triggerKey) throws JobPersistenceException {
        return this.assembler.triggerStateManager.getState(triggerKey);
    }

    public void pauseTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        this.assembler.triggerStateManager.pause(triggerKey);
    }

    public Collection<String> pauseTriggers(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        return this.assembler.triggerStateManager.pause(matcher);
    }

    public void resumeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        this.assembler.triggerStateManager.resume(triggerKey);
    }

    public Collection<String> resumeTriggers(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        return this.assembler.triggerStateManager.resume(matcher);
    }

    public Set<String> getPausedTriggerGroups() throws JobPersistenceException {
        return this.assembler.triggerStateManager.getPausedTriggerGroups();
    }

    public Set<String> getPausedJobGroups() throws JobPersistenceException {
        return this.assembler.pausedJobGroupsDao.getPausedGroups();
    }

    public void pauseAll() throws JobPersistenceException {
        this.assembler.triggerStateManager.pauseAll();
    }

    public void resumeAll() throws JobPersistenceException {
        this.assembler.triggerStateManager.resumeAll();
    }

    public void pauseJob(JobKey jobKey) throws JobPersistenceException {
        this.assembler.triggerStateManager.pauseJob(jobKey);
    }

    public Collection<String> pauseJobs(GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        return this.assembler.triggerStateManager.pauseJobs(groupMatcher);
    }

    public void resumeJob(JobKey jobKey) throws JobPersistenceException {
        this.assembler.triggerStateManager.resume(jobKey);
    }

    public Collection<String> resumeJobs(GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        return this.assembler.triggerStateManager.resumeJobs(groupMatcher);
    }

    public List<OperableTrigger> acquireNextTriggers(long noLaterThan, int maxCount, long timeWindow) throws JobPersistenceException {
        return this.assembler.triggerRunner.acquireNext(noLaterThan, maxCount, timeWindow);
    }

    public void releaseAcquiredTrigger(OperableTrigger trigger) {
        this.assembler.lockManager.unlockAcquiredTrigger(trigger);
    }

    public void resetTriggerFromErrorState(TriggerKey triggerKey) {
        this.assembler.triggerStateManager.resetTriggerFromErrorState(triggerKey);
    }

    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> triggers) throws JobPersistenceException {
        return this.assembler.triggerRunner.triggersFired(triggers);
    }

    public void triggeredJobComplete(OperableTrigger trigger, JobDetail job, Trigger.CompletedExecutionInstruction triggerInstCode) {
        this.assembler.jobCompleteHandler.jobComplete(trigger, job, triggerInstCode);
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setInstanceName(String schedName) {
        this.schedulerName = schedName;
    }

    public void setThreadPoolSize(int poolSize) {
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses.split(",");
    }

    public MongoCollection<Document> getJobCollection() {
        return this.assembler.jobDao.getCollection();
    }

    public MongoCollection<Document> getTriggerCollection() {
        return this.assembler.triggerDao.getCollection();
    }

    public MongoCollection<Document> getCalendarCollection() {
        return this.assembler.calendarDao.getCollection();
    }

    public MongoCollection<Document> getLocksCollection() {
        return this.assembler.locksDao.getCollection();
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setCollectionPrefix(String prefix) {
        this.collectionPrefix = prefix + "_";
    }

    public void setMongoUri(String mongoUri) {
        this.mongoUri = mongoUri;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setMisfireThreshold(long misfireThreshold) {
        this.misfireThreshold = misfireThreshold;
    }

    public void setTriggerTimeoutMillis(long triggerTimeoutMillis) {
        this.triggerTimeoutMillis = triggerTimeoutMillis;
    }

    public void setJobTimeoutMillis(long jobTimeoutMillis) {
        this.jobTimeoutMillis = jobTimeoutMillis;
    }

    private void ensureIndexes() throws SchedulerConfigException {
        try {
            this.assembler.jobDao.createIndex();
            this.assembler.triggerDao.createIndex();
            this.assembler.locksDao.createIndex(this.isClustered());
            this.assembler.calendarDao.createIndex();
            this.assembler.schedulerDao.createIndex();
            try {
                this.assembler.jobDao.dropIndex();
                this.assembler.triggerDao.dropIndex();
                this.assembler.locksDao.dropIndex();
            }
            catch (MongoCommandException mongoCommandException) {}
        }
        catch (MongoException e) {
            throw new SchedulerConfigException("Error while initializing the indexes", (Throwable)e);
        }
    }

    public void setMongoOptionMaxConnections(int maxConnections) {
        this.mongoOptionMaxConnections = maxConnections;
    }

    public void setMongoOptionConnectTimeoutMillis(int maxConnectWaitTime) {
        this.mongoOptionConnectTimeoutMillis = maxConnectWaitTime;
    }

    public void setMongoOptionReadTimeoutMillis(int readTimeoutMillis) {
        this.mongoOptionReadTimeoutMillis = readTimeoutMillis;
    }

    public void setMongoOptionSocketKeepAlive(boolean socketKeepAlive) {
        this.mongoOptionSocketKeepAlive = socketKeepAlive;
    }

    public void setMongoOptionEnableSSL(boolean enableSSL) {
        this.mongoOptionEnableSSL = enableSSL;
    }

    public void setMongoOptionSslInvalidHostNameAllowed(boolean sslInvalidHostNameAllowed) {
        this.mongoOptionSslInvalidHostNameAllowed = sslInvalidHostNameAllowed;
    }

    public void setMongoOptionTrustStorePath(String trustStorePath) {
        this.mongoOptionTrustStorePath = trustStorePath;
    }

    public void setMongoOptionTrustStorePassword(String trustStorePassword) {
        this.mongoOptionTrustStorePassword = trustStorePassword;
    }

    public void setMongoOptionTrustStoreType(String trustStoreType) {
        this.mongoOptionTrustStoreType = trustStoreType;
    }

    public void setMongoOptionKeyStorePath(String keyStorePath) {
        this.mongoOptionKeyStorePath = keyStorePath;
    }

    public void setMongoOptionKeyStorePassword(String keyStorePassword) {
        this.mongoOptionKeyStorePassword = keyStorePassword;
    }

    public void setMongoOptionKeyStoreType(String keyStoreType) {
        this.mongoOptionKeyStoreType = keyStoreType;
    }

    public void setMongoOptionWriteConcernW(String mongoOptionWriteConcernW) {
        this.mongoOptionWriteConcernW = mongoOptionWriteConcernW;
    }

    public void setMongoOptionWriteConcernTimeoutMillis(int writeConcernTimeoutMillis) {
        this.mongoOptionWriteConcernTimeoutMillis = writeConcernTimeoutMillis;
    }

    public String getAuthDbName() {
        return this.authDbName;
    }

    public void setAuthDbName(String authDbName) {
        this.authDbName = authDbName;
    }
}

