/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb;

import com.novemberain.quartz.mongodb.JobDataConverter;
import org.bson.Document;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.spi.ClassLoadHelper;

public class JobConverter {
    public static final String JOB_DURABILITY = "durability";
    private static final String JOB_CLASS = "jobClass";
    private static final String JOB_DESCRIPTION = "jobDescription";
    public static final String JOB_REQUESTS_RECOVERY = "requestsRecovery";
    private ClassLoadHelper loadHelper;
    private final JobDataConverter jobDataConverter;

    public JobConverter(ClassLoadHelper loadHelper, JobDataConverter jobDataConverter) {
        this.loadHelper = loadHelper;
        this.jobDataConverter = jobDataConverter;
    }

    public Document toDocument(JobDetail newJob, JobKey key) throws JobPersistenceException {
        Document job = new Document();
        job.put("keyName", (Object)key.getName());
        job.put("keyGroup", (Object)key.getGroup());
        job.put(JOB_DESCRIPTION, (Object)newJob.getDescription());
        job.put(JOB_CLASS, (Object)newJob.getJobClass().getName());
        job.put(JOB_DURABILITY, (Object)newJob.isDurable());
        job.put(JOB_REQUESTS_RECOVERY, (Object)newJob.requestsRecovery());
        this.jobDataConverter.toDocument(newJob.getJobDataMap(), job);
        return job;
    }

    public JobDetail toJobDetail(Document doc) throws JobPersistenceException {
        try {
            Class<Job> jobClass = this.loadHelper.getClassLoader().loadClass(doc.getString((Object)JOB_CLASS));
            JobBuilder builder = this.createJobBuilder(doc, jobClass);
            this.withDurability(doc, builder);
            this.withRequestsRecovery(doc, builder);
            JobDataMap jobData = this.createJobDataMap(doc);
            return builder.usingJobData(jobData).build();
        }
        catch (ClassNotFoundException e) {
            throw new JobPersistenceException("Could not load job class " + String.valueOf(doc.get((Object)JOB_CLASS)), (Throwable)e);
        }
    }

    private JobDataMap createJobDataMap(Document doc) throws JobPersistenceException {
        JobDataMap jobData = new JobDataMap();
        if (!this.jobDataConverter.toJobData(doc, jobData)) {
            for (String key : doc.keySet()) {
                if (key.equals("keyName") || key.equals("keyGroup") || key.equals(JOB_CLASS) || key.equals(JOB_DESCRIPTION) || key.equals(JOB_DURABILITY) || key.equals(JOB_REQUESTS_RECOVERY) || key.equals("_id")) continue;
                jobData.put(key, doc.get((Object)key));
            }
        }
        jobData.clearDirtyFlag();
        return jobData;
    }

    private void withDurability(Document doc, JobBuilder builder) throws JobPersistenceException {
        Object jobDurability = doc.get((Object)JOB_DURABILITY);
        if (jobDurability != null) {
            if (jobDurability instanceof Boolean) {
                builder.storeDurably(((Boolean)jobDurability).booleanValue());
            } else if (jobDurability instanceof String) {
                builder.storeDurably(Boolean.valueOf((String)jobDurability).booleanValue());
            } else {
                throw new JobPersistenceException("Illegal value for durability, class " + String.valueOf(jobDurability.getClass()) + " not supported");
            }
        }
    }

    private void withRequestsRecovery(Document doc, JobBuilder builder) {
        if (doc.getBoolean((Object)JOB_REQUESTS_RECOVERY, false)) {
            builder.requestRecovery(true);
        }
    }

    private JobBuilder createJobBuilder(Document doc, Class<Job> jobClass) {
        return JobBuilder.newJob(jobClass).withIdentity(doc.getString((Object)"keyName"), doc.getString((Object)"keyGroup")).withDescription(doc.getString((Object)JOB_DESCRIPTION));
    }
}

