/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.AnnotationsMapper;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphQLTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.InputValueDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperFactory;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.NamedDefinition;
import com.kobylynskyi.graphql.codegen.model.ProjectionParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.builders.DeprecatedDefinitionBuilder;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedInterfaceTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedUnionTypeDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RequestResponseDefinitionToDataModelMapper {
    private final GraphQLTypeMapper graphQLTypeMapper;
    private final AnnotationsMapper annotationsMapper;
    private final DataModelMapper dataModelMapper;
    private final FieldDefinitionToParameterMapper fieldDefinitionToParameterMapper;
    private final InputValueDefinitionToParameterMapper inputValueDefinitionToParameterMapper;

    public RequestResponseDefinitionToDataModelMapper(MapperFactory mapperFactory, FieldDefinitionToParameterMapper fieldDefinitionToParameterMapper, InputValueDefinitionToParameterMapper inputValDefToParamMapper) {
        this.graphQLTypeMapper = mapperFactory.getGraphQLTypeMapper();
        this.annotationsMapper = mapperFactory.getAnnotationsMapper();
        this.dataModelMapper = mapperFactory.getDataModelMapper();
        this.fieldDefinitionToParameterMapper = fieldDefinitionToParameterMapper;
        this.inputValueDefinitionToParameterMapper = inputValDefToParamMapper;
    }

    private static String getClassName(ExtendedFieldDefinition operationDef, List<String> fieldNames, String objectType, String suffix) {
        StringBuilder classNameBuilder = new StringBuilder();
        classNameBuilder.append(Utils.capitalize(operationDef.getName()));
        if (Collections.frequency(fieldNames, operationDef.getName()) > 1) {
            classNameBuilder.append(DataModelMapper.getClassNameSuffixWithInputValues(operationDef));
        }
        classNameBuilder.append(objectType);
        if (Utils.isNotBlank(suffix)) {
            classNameBuilder.append(suffix);
        }
        return classNameBuilder.toString();
    }

    private static ProjectionParameterDefinition getChildDefinition(MappingContext mappingContext, String childName) {
        ProjectionParameterDefinition parameter = new ProjectionParameterDefinition();
        parameter.setName("...on " + childName);
        parameter.setMethodName("on" + childName);
        parameter.setType(Utils.capitalize(childName + mappingContext.getResponseProjectionSuffix()));
        return parameter;
    }

    private static ProjectionParameterDefinition getTypeNameProjectionParameterDefinition() {
        ProjectionParameterDefinition typeNameProjParamDef = new ProjectionParameterDefinition();
        typeNameProjParamDef.setName("__typename");
        typeNameProjParamDef.setMethodName("typename");
        return typeNameProjParamDef;
    }

    public Map<String, Object> mapResponseProjection(MappingContext mappingContext, ExtendedDefinition<?, ?> definition) {
        String className = Utils.capitalize(definition.getName()) + mappingContext.getResponseProjectionSuffix();
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", DataModelMapper.getModelPackageName(mappingContext));
        dataModel.put("className", className);
        dataModel.put("annotations", this.annotationsMapper.getAnnotations(mappingContext, className));
        dataModel.put("javaDoc", Collections.singletonList("Response projection for " + definition.getName()));
        dataModel.put("fields", this.getProjectionFields(mappingContext, definition));
        dataModel.put("builder", mappingContext.getGenerateBuilder());
        dataModel.put("equalsAndHashCode", mappingContext.getGenerateEqualsAndHashCode());
        dataModel.put("generatedAnnotation", mappingContext.getAddGeneratedAnnotation());
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        dataModel.put("generateAllMethodInProjection", mappingContext.getGenerateAllMethodInProjection());
        dataModel.put("responseProjectionMaxDepth", mappingContext.getResponseProjectionMaxDepth());
        return dataModel;
    }

    public Map<String, Object> mapParametrizedInput(MappingContext mappingContext, ExtendedFieldDefinition fieldDefinition, ExtendedDefinition<?, ?> parentTypeDefinition) {
        String className = DataModelMapper.getParametrizedInputClassName(mappingContext, fieldDefinition, parentTypeDefinition);
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", DataModelMapper.getModelPackageName(mappingContext));
        dataModel.put("className", className);
        dataModel.put("annotations", this.annotationsMapper.getAnnotations(mappingContext, className));
        dataModel.put("javaDoc", Collections.singletonList(String.format("Parametrized input for field %s in type %s", fieldDefinition.getName(), parentTypeDefinition.getName())));
        dataModel.put("fields", this.inputValueDefinitionToParameterMapper.map(mappingContext, fieldDefinition.getInputValueDefinitions(), parentTypeDefinition.getName()));
        dataModel.put("builder", mappingContext.getGenerateBuilder());
        dataModel.put("equalsAndHashCode", mappingContext.getGenerateEqualsAndHashCode());
        dataModel.put("generatedAnnotation", mappingContext.getAddGeneratedAnnotation());
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        dataModel.put("enumImportItSelfInScala", mappingContext.getEnumImportItSelfInScala());
        dataModel.put("generateNoArgsConstructorOnly", mappingContext.isGenerateNoArgsConstructorOnly());
        return dataModel;
    }

    public Map<String, Object> mapResponse(MappingContext mappingContext, ExtendedFieldDefinition operationDef, String objectTypeName, List<String> fieldNames) {
        String className = RequestResponseDefinitionToDataModelMapper.getClassName(operationDef, fieldNames, objectTypeName, mappingContext.getResponseSuffix());
        NamedDefinition namedDefinition = this.graphQLTypeMapper.getLanguageType(mappingContext, operationDef.getType(), operationDef.getName(), objectTypeName);
        String returnType = this.graphQLTypeMapper.getResponseReturnType(mappingContext, namedDefinition, namedDefinition.getJavaName());
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", DataModelMapper.getModelPackageName(mappingContext));
        dataModel.put("annotations", this.annotationsMapper.getAnnotations(mappingContext, className));
        dataModel.put("className", className);
        dataModel.put("javaDoc", operationDef.getJavaDoc());
        dataModel.put("deprecated", DeprecatedDefinitionBuilder.build(mappingContext, operationDef));
        dataModel.put("operationName", operationDef.getName());
        dataModel.put("methodName", this.dataModelMapper.capitalizeMethodNameIfRestricted(mappingContext, operationDef.getName()));
        dataModel.put("returnTypeName", returnType);
        dataModel.put("generatedAnnotation", mappingContext.getAddGeneratedAnnotation());
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        return dataModel;
    }

    public Map<String, Object> mapRequest(MappingContext mappingContext, ExtendedFieldDefinition operationDef, String objectTypeName, List<String> fieldNames) {
        String className = RequestResponseDefinitionToDataModelMapper.getClassName(operationDef, fieldNames, objectTypeName, mappingContext.getRequestSuffix());
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", DataModelMapper.getModelPackageName(mappingContext));
        dataModel.put("annotations", this.annotationsMapper.getAnnotations(mappingContext, className));
        dataModel.put("className", className);
        dataModel.put("javaDoc", operationDef.getJavaDoc());
        dataModel.put("operationName", operationDef.getName());
        dataModel.put("operationType", objectTypeName.toUpperCase());
        dataModel.put("fields", this.inputValueDefinitionToParameterMapper.map(mappingContext, operationDef.getInputValueDefinitions(), operationDef.getName()));
        dataModel.put("builder", mappingContext.getGenerateBuilder());
        dataModel.put("equalsAndHashCode", mappingContext.getGenerateEqualsAndHashCode());
        dataModel.put("toString", mappingContext.getGenerateToString());
        dataModel.put("toStringForRequest", mappingContext.getGenerateClient());
        dataModel.put("generatedAnnotation", mappingContext.getAddGeneratedAnnotation());
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        dataModel.put("enumImportItSelfInScala", mappingContext.getEnumImportItSelfInScala());
        return dataModel;
    }

    private Collection<ProjectionParameterDefinition> getProjectionFields(MappingContext mappingContext, ExtendedDefinition<?, ?> definition) {
        if (definition instanceof ExtendedObjectTypeDefinition) {
            return this.getProjectionFields(mappingContext, (ExtendedObjectTypeDefinition)definition);
        }
        if (definition instanceof ExtendedUnionTypeDefinition) {
            return RequestResponseDefinitionToDataModelMapper.getProjectionFields(mappingContext, (ExtendedUnionTypeDefinition)definition);
        }
        if (definition instanceof ExtendedInterfaceTypeDefinition) {
            return this.getProjectionFields(mappingContext, (ExtendedInterfaceTypeDefinition)definition);
        }
        return Collections.emptyList();
    }

    private static Collection<ProjectionParameterDefinition> getProjectionFields(MappingContext mappingContext, ExtendedUnionTypeDefinition unionDefinition) {
        LinkedHashMap<String, ProjectionParameterDefinition> allParameters = new LinkedHashMap<String, ProjectionParameterDefinition>();
        for (String memberTypeName : unionDefinition.getMemberTypeNames()) {
            ProjectionParameterDefinition memberDef = RequestResponseDefinitionToDataModelMapper.getChildDefinition(mappingContext, memberTypeName);
            allParameters.put(memberDef.getMethodName(), memberDef);
        }
        ProjectionParameterDefinition typeNameProjParamDef = RequestResponseDefinitionToDataModelMapper.getTypeNameProjectionParameterDefinition();
        allParameters.put(typeNameProjParamDef.getMethodName(), typeNameProjParamDef);
        return allParameters.values();
    }

    private Collection<ProjectionParameterDefinition> getProjectionFields(MappingContext mappingContext, ExtendedObjectTypeDefinition typeDefinition) {
        LinkedHashMap<String, ProjectionParameterDefinition> allParameters = new LinkedHashMap<String, ProjectionParameterDefinition>();
        this.fieldDefinitionToParameterMapper.mapProjectionFields(mappingContext, typeDefinition.getFieldDefinitions(), typeDefinition).forEach(p -> allParameters.put(p.getMethodName(), (ProjectionParameterDefinition)p));
        List<ExtendedInterfaceTypeDefinition> interfacesOfType = DataModelMapper.getInterfacesOfType(typeDefinition, mappingContext.getDocument());
        interfacesOfType.stream().map(i -> this.fieldDefinitionToParameterMapper.mapProjectionFields(mappingContext, i.getFieldDefinitions(), (ExtendedDefinition<?, ?>)i)).flatMap(Collection::stream).filter(paramDef -> !allParameters.containsKey(paramDef.getMethodName())).forEach(paramDef -> allParameters.put(paramDef.getMethodName(), (ProjectionParameterDefinition)paramDef));
        ProjectionParameterDefinition typeNameProjParamDef = RequestResponseDefinitionToDataModelMapper.getTypeNameProjectionParameterDefinition();
        allParameters.put(typeNameProjParamDef.getMethodName(), typeNameProjParamDef);
        return allParameters.values();
    }

    private Collection<ProjectionParameterDefinition> getProjectionFields(MappingContext mappingContext, ExtendedInterfaceTypeDefinition interfaceDefinition) {
        LinkedHashMap<String, ProjectionParameterDefinition> allParameters = new LinkedHashMap<String, ProjectionParameterDefinition>();
        this.fieldDefinitionToParameterMapper.mapProjectionFields(mappingContext, interfaceDefinition.getFieldDefinitions(), interfaceDefinition).forEach(p -> allParameters.put(p.getMethodName(), (ProjectionParameterDefinition)p));
        DataModelMapper.getInterfacesOfType(interfaceDefinition, mappingContext.getDocument()).stream().map(i -> this.fieldDefinitionToParameterMapper.mapProjectionFields(mappingContext, i.getFieldDefinitions(), (ExtendedDefinition<?, ?>)i)).flatMap(Collection::stream).filter(paramDef -> !allParameters.containsKey(paramDef.getMethodName())).forEach(paramDef -> allParameters.put(paramDef.getMethodName(), (ProjectionParameterDefinition)paramDef));
        Set interfaceChildren = mappingContext.getInterfaceChildren().getOrDefault(interfaceDefinition.getName(), Collections.emptySet());
        for (String childName : interfaceChildren) {
            ProjectionParameterDefinition childDef = RequestResponseDefinitionToDataModelMapper.getChildDefinition(mappingContext, childName);
            allParameters.put(childDef.getMethodName(), childDef);
        }
        ProjectionParameterDefinition typeNameProjParamDef = RequestResponseDefinitionToDataModelMapper.getTypeNameProjectionParameterDefinition();
        allParameters.put(typeNameProjParamDef.getMethodName(), typeNameProjParamDef);
        return allParameters.values();
    }
}

