/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.yaml.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.kbuntrock.model.DataObject;
import io.github.kbuntrock.yaml.model.Schema;
import java.util.Map;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Property
extends Schema {
    @JsonIgnore
    private String name;
    @JsonIgnore
    private Integer minLength;
    @JsonIgnore
    private Integer maxLength;
    @JsonIgnore
    private boolean required;
    @JsonIgnore
    private DataObject parentDataObject;

    public Property() {
    }

    public Property(Schema schema) {
        this.setProperties(schema.getProperties());
        this.setAdditionalProperties(schema.getAdditionalProperties());
        this.setItems(schema.getItems());
        this.setType(schema.getType());
        this.setRequired(schema.getRequired());
        this.setReference(schema.getReference());
        this.setEnumValues(schema.getEnumValues());
    }

    public Property(DataObject dataObject, boolean mainReference, String name, Set<String> exploredSignatures, DataObject parentDataObject) {
        super(dataObject, mainReference, exploredSignatures, parentDataObject, name);
        if (dataObject.getClassRequired() != null) {
            this.setRequired(dataObject.getClassRequired());
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> getJsonObject() {
        Map<String, Object> map = super.getJsonObject();
        if (this.minLength != null) {
            map.put("minLength", this.minLength);
        }
        if (this.maxLength != null) {
            map.put("maxLength", this.maxLength);
        }
        return map;
    }
}

