/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.yaml.model;

import io.github.kbuntrock.model.DataObject;
import io.github.kbuntrock.model.ParameterObject;
import io.github.kbuntrock.utils.OpenApiDataType;
import io.github.kbuntrock.utils.OpenApiTypeResolver;
import io.github.kbuntrock.yaml.model.Property;
import io.github.kbuntrock.yaml.model.Schema;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.springframework.web.multipart.MultipartFile;

public class Content {
    private Schema schema;

    public static Content fromDataObject(ParameterObject parameterObject) {
        boolean isMultipartFile;
        Content content = Content.fromDataObject((DataObject)parameterObject);
        boolean bl = isMultipartFile = MultipartFile.class == parameterObject.getJavaClass() || OpenApiDataType.ARRAY == parameterObject.getOpenApiResolvedType().getType() && MultipartFile.class == parameterObject.getArrayItemDataObject().getJavaClass();
        if (isMultipartFile) {
            Schema schema;
            Content multipartContent = new Content();
            multipartContent.schema = schema = new Schema();
            if (parameterObject.isRequired()) {
                schema.setRequired(Collections.singletonList(parameterObject.getName()));
            }
            schema.setType(OpenApiTypeResolver.INSTANCE.resolveFromJavaClass(Object.class));
            LinkedHashMap<String, Property> propertyMap = new LinkedHashMap<String, Property>();
            schema.setProperties(propertyMap);
            Property property = new Property(content.getSchema());
            propertyMap.put(parameterObject.getName(), property);
            return multipartContent;
        }
        return content;
    }

    public static Content fromDataObject(DataObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        HashSet<String> exploredSignatures = new HashSet<String>();
        Content content = new Content();
        content.schema = new Schema(dataObject, exploredSignatures);
        return content;
    }

    public Schema getSchema() {
        return this.schema;
    }
}

