/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.utils;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum OpenApiDataType {
    STRING,
    BOOLEAN,
    INTEGER,
    NUMBER,
    ARRAY,
    OBJECT;

    private static final Map<String, OpenApiDataType> map;

    public static OpenApiDataType fromJsonNode(JsonNode jsonNode) {
        JsonNode typeNode = jsonNode.get("type");
        return map.getOrDefault(typeNode.asText(), OBJECT);
    }

    static {
        map = new HashMap<String, OpenApiDataType>();
        for (OpenApiDataType type : OpenApiDataType.values()) {
            map.put(type.toString().toLowerCase(Locale.ENGLISH), type);
        }
    }
}

