/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.reflection;

import io.github.kbuntrock.reflection.GenericArrayTypeImpl;
import io.github.kbuntrock.reflection.ParameterizedTypeImpl;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ClassGenericityResolver {
    private final Class<?> clazz;
    private final boolean genericallyTyped = false;
    private final Map<Method, Class> methodToClass;
    private final Map<Class, Map<String, Type>> classToMap;

    public ClassGenericityResolver(Class<?> clazz) {
        this.clazz = clazz;
        this.methodToClass = new HashMap<Method, Class>();
        this.classToMap = new HashMap<Class, Map<String, Type>>();
    }

    public void initForMethod(Method method) {
        if (this.methodToClass.containsKey(method)) {
            return;
        }
        this.methodToClass.put(method, null);
        ArrayList<ClassType> classTypeList = new ArrayList<ClassType>();
        ClassType first = new ClassType();
        first.clazz = this.clazz;
        first.type = null;
        classTypeList.add(first);
        Class<?> searched = this.clazz;
        while (!searched.equals(method.getDeclaringClass())) {
            Type type = searched.getGenericSuperclass();
            searched = searched.getSuperclass();
            ClassType classType = new ClassType();
            classType.clazz = searched;
            classType.type = type;
            classTypeList.add(classType);
        }
        this.methodToClass.put(method, searched);
        if (this.classToMap.containsKey(searched)) {
            return;
        }
        if (classTypeList.size() > 1) {
            HashMap fullyResolvedMap = new HashMap();
            for (int i = 1; i < classTypeList.size(); ++i) {
                if (!(((ClassType)classTypeList.get((int)i)).type instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)((ClassType)classTypeList.get((int)i)).type;
                HashMap<String, Type> genericNameToTypeMap = new HashMap<String, Type>();
                for (int j = 0; j < pt.getActualTypeArguments().length; ++j) {
                    if (fullyResolvedMap.containsKey(pt.getActualTypeArguments()[j].getTypeName())) {
                        genericNameToTypeMap.put(((ClassType)classTypeList.get((int)i)).clazz.getTypeParameters()[j].getTypeName(), (Type)fullyResolvedMap.get(pt.getActualTypeArguments()[j].getTypeName()));
                        continue;
                    }
                    genericNameToTypeMap.put(((ClassType)classTypeList.get((int)i)).clazz.getTypeParameters()[j].getTypeName(), pt.getActualTypeArguments()[j]);
                }
                fullyResolvedMap = genericNameToTypeMap;
            }
            this.classToMap.put(searched, fullyResolvedMap);
        }
    }

    private void doContextualSubstitution(ParameterizedTypeImpl substitution, Map<String, Type> genericNameToTypeMap, Method method) {
        for (int i = 0; i < substitution.getActualTypeArguments().length; ++i) {
            if (genericNameToTypeMap.containsKey(substitution.getActualTypeArguments()[i].getTypeName())) {
                substitution.getActualTypeArguments()[i] = genericNameToTypeMap.get(substitution.getActualTypeArguments()[i].getTypeName());
            }
            substitution.getActualTypeArguments()[i] = this.getContextualType(substitution.getActualTypeArguments()[i], method);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Type getContextualType(Type genericType, Method method) {
        Map<String, Type> genericNameToTypeMap = this.classToMap.get(this.methodToClass.get(method));
        if (genericNameToTypeMap != null) {
            if (genericType instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)genericType;
                if (!genericNameToTypeMap.containsKey(typeVariable.getName())) return genericType;
                return genericNameToTypeMap.get(typeVariable.getName());
            }
            if (genericType instanceof ParameterizedType) {
                ParameterizedTypeImpl substitution = new ParameterizedTypeImpl((ParameterizedType)genericType);
                this.doContextualSubstitution(substitution, genericNameToTypeMap, method);
                return substitution;
            }
            if (!(genericType instanceof GenericArrayType)) return genericType;
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            if (genericArrayType.getGenericComponentType() instanceof ParameterizedType) {
                ParameterizedTypeImpl substitution = new ParameterizedTypeImpl((ParameterizedType)genericArrayType.getGenericComponentType());
                this.doContextualSubstitution(substitution, genericNameToTypeMap, method);
                return new GenericArrayTypeImpl(substitution);
            }
            if (!(genericArrayType.getGenericComponentType() instanceof TypeVariable)) throw new RuntimeException("Type : " + ((GenericArrayType)genericType).getGenericComponentType().getClass().toString() + " not handled in generic array contextual substitution.");
            TypeVariable typeVariable = (TypeVariable)genericArrayType.getGenericComponentType();
            if (!genericNameToTypeMap.containsKey(typeVariable.getName())) return genericType;
            return new GenericArrayTypeImpl(genericNameToTypeMap.get(typeVariable.getName()));
        }
        if (!(genericType instanceof ParameterizedType)) return genericType;
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        if (parameterizedType.getRawType() != Class.class) return genericType;
        if (parameterizedType.getActualTypeArguments().length != 1) return genericType;
        if (!(parameterizedType.getActualTypeArguments()[0] instanceof WildcardType)) return genericType;
        WildcardType wt = (WildcardType)parameterizedType.getActualTypeArguments()[0];
        if (wt.getLowerBounds().length != 0) return genericType;
        if (wt.getUpperBounds().length != 1) return genericType;
        return wt.getUpperBounds()[0];
    }

    private class ClassType {
        public Class clazz;
        public Type type;

        private ClassType() {
        }
    }
}

