/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration.parser;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.kbuntrock.MojoRuntimeException;
import io.github.kbuntrock.configuration.parser.JsonParserUtils;
import io.github.kbuntrock.configuration.parser.YamlParserUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;

public final class CommonParserUtils {
    private CommonParserUtils() {
    }

    public static String getContentFromFileOrText(MavenProject mavenProject, String input) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            return null;
        }
        String content = input;
        String url = mavenProject.getBasedir() + FileSystems.getDefault().getSeparator() + input;
        Path path = null;
        try {
            path = Paths.get(url, new String[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (path != null && path.toFile().exists() && !path.toFile().isDirectory()) {
            try {
                List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
                StringBuilder sb = new StringBuilder();
                for (String line : lines) {
                    sb.append(line);
                }
                content = sb.toString();
            }
            catch (IOException e) {
                throw new MojoRuntimeException("Cannot read content from file", e);
            }
        }
        return content;
    }

    public static Optional<JsonNode> parse(MavenProject mavenProject, String input) {
        boolean isYaml = input.endsWith(".yml") || input.endsWith(".yaml");
        String content = CommonParserUtils.getContentFromFileOrText(mavenProject, input);
        if (isYaml) {
            return Optional.ofNullable(YamlParserUtils.readFile(mavenProject.getBasedir() + FileSystems.getDefault().getSeparator() + input));
        }
        return JsonParserUtils.parse(content);
    }
}

